/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.io;

import java.math.BigDecimal;

import benten.twa.io.messages.BentenTwaProcessUtilMessages;
import benten.twa.process.BentenProcessResultInfo;

/**
 * 翻訳ワークフローの処理ユーティリティ。
 * 
 * @author KASHIHARA Shinji
 * @author IGA Tosiki
 */
public class BentenTwaProcessUtil {
	/**
	 * 翻訳ワークフロー処理ユーティリティのためのメッセージ。
	 */
	protected static final BentenTwaProcessUtilMessages fMsg = new BentenTwaProcessUtilMessages();

	/**
	 * 隠されたコンストラクター。
	 * 
	 * <UL>
	 * <LI>このクラスはユーティリティ・クラスです。
	 * <LI>インスタンス生成を抑制するために、コンストラクターは private で修飾されています。
	 * </UL>
	 */
	private BentenTwaProcessUtil() {
	}

	/**
	 * 処理結果情報から結果メッセージ文字列を取得。
	 * @param info 処理結果情報。
	 * @return 処理結果の文字列表現。
	 */
	public static final String getResultMessage(final BentenProcessResultInfo info) {
		// ダイアログやコマンドラインに表示するメッセージの作成
		final StringBuffer sb = new StringBuffer();
		sb.append(fMsg.getMsgSuccess(BigDecimal.valueOf(info.getSuccessCount())));
		if (info.getWarningCount() > 0) {
			sb.append(fMsg.getMsgWarning(BigDecimal.valueOf(info.getWarningCount())));
		}
		if (info.getSkipCount() > 0) {
			sb.append(fMsg.getMsgSkipped(BigDecimal.valueOf(info.getSkipCount())));
		}
		if (info.getUnitCount() > 0) {
			sb.append("\n"); //$NON-NLS-1$
			sb.append(fMsg.getMsgUnitSuccess(BigDecimal.valueOf(info.getUnitCount())));
		}
		return sb.toString();
	}
}
