/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.ui.internal.tabletree;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.xml.ui.internal.tabletree.IDesignViewer;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;

import benten.cat.ui.CatUiPlugin;
import benten.cat.ui.internal.tabletree.messages.XLIFFMultiPageEditorPartMessages;
import benten.cat.ui.viewers.TransUnitViewer;

/**
 * XLIFF マルチ・ページ・エディター・パーツ。
 * <p>
 * ★基本設計「翻訳支援機能: 翻訳中間形式エディター機能: 翻訳中間形式(XLIFF)保存」に対応します。
 *
 * @author KASHIHARA Shinji
 */
@SuppressWarnings("restriction")
public class XLIFFMultiPageEditorPart extends XMLMultiPageEditorPart {

	/**
	 * XLIFF マルチ・ページ・エディター・パーツのためのメッセージ。
	 */
	protected static final XLIFFMultiPageEditorPartMessages fMsg = new XLIFFMultiPageEditorPartMessages();

	/** 翻訳単位ビューアー */
	protected TransUnitViewer fTransUnitViewer;

	/**
	 * 翻訳単位ビューアーの取得。
	 * @return 翻訳単位ビューアー
	 */
	public TransUnitViewer getTransUnitViewer() {
		return fTransUnitViewer;
	}

	@Override
	protected IDesignViewer createDesignPage() {
		fTransUnitViewer = new TransUnitViewer(getContainer(), this);
		return fTransUnitViewer;
	}

	@Override
	protected void createPages() {
		super.createPages();
		final CTabFolder tabFolder = (CTabFolder) getContainer();
		tabFolder.getItem(0).setImage(CatUiPlugin.getDefault().getImage("icons/tabtransunit.gif")); //$NON-NLS-1$
		tabFolder.getItem(1).setImage(CatUiPlugin.getDefault().getImage("icons/tabsource.gif")); //$NON-NLS-1$
	}

	@Override
	@SuppressWarnings("unchecked")
	public Object getAdapter(final Class key) {
		// Eclipse 標準のインターフェースでプラグイン間連携を行なうための実装です。
		if (key == ISourceViewer.class) {
			final ISourceViewer sourceViewer = fTransUnitViewer.getTargetViewer();
			return (sourceViewer.isEditable()) ? sourceViewer : null;
		} else if (key == IStructuredSelection.class) {
			final IFile file = ((IFileEditorInput) getEditorInput()).getFile();
			return new StructuredSelection(file);
		}
		return super.getAdapter(key);
	}

	@Override
	public void setFocus() {
		super.setFocus();
		// エディター切り替え時に用語集ビューも切り替えます。
		fTransUnitViewer.showGlossary();
	}

	/**
	 * 翻訳単位タブの表示。
	 */
	public void showDesignPage() {
		if (getActivePage() != 0) {
			setActivePage(0);
		}
	}
}
