/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.stat.views;

import org.eclipse.swt.SWT;

import benten.cat.stat.model.TmHitRateModel;
import benten.cat.stat.views.messages.TmHitRateViewMessages;
import benten.ui.views.AutoColumnWidthTableViewer;
import benten.ui.views.TableLabelProvider;

/**
 * 翻訳メモリー・ヒット率ビュー。
 * <p>
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳統計取得機能: 翻訳メモリー・ヒット率ビュー」に対応します。
 *
 * @author KASHIHARA Shinji
 */
public class TmHitRateView extends AbstractStatView {
	/**
	 * 翻訳メモリー・ヒット率ビューのためのメッセージ。
	 */
	protected static final TmHitRateViewMessages fMsg = new TmHitRateViewMessages();

	@Override
	protected void createTableViewer(final AutoColumnWidthTableViewer viewer) {
		viewer.addColumn(fMsg.getResource(), 15);
		viewer.addColumn(fMsg.getExactMatch(), 7, SWT.RIGHT);
		viewer.addColumn(fMsg.getMoreThan95(), 7, SWT.RIGHT);
		viewer.addColumn(fMsg.getMoreThan85(), 7, SWT.RIGHT);
		viewer.addColumn(fMsg.getMoreThan75(), 7, SWT.RIGHT);
		viewer.addColumn(fMsg.getLessThan75(), 7, SWT.RIGHT);

		viewer.setLabelProvider(new TableLabelProvider() {
			public String getColumnText(final Object obj, final int index) {
				final TmHitRateModel entry = (TmHitRateModel) obj;
				switch (index) {
				case 0:
					return entry.getFile().toString();
				case 1:
					return String.valueOf(entry.getMatch100());
				case 2:
					return String.valueOf(entry.getMatch95());
				case 3:
					return String.valueOf(entry.getMatch85());
				case 4:
					return String.valueOf(entry.getMatch75());
				case 5:
					return String.valueOf(entry.getMatchUnder75());
				}
				return getText(obj);
			}
		});
	}
}
