/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.stat.handler;

import java.io.File;
import java.io.IOException;
import java.util.List;

import org.xml.sax.SAXException;

import benten.cat.stat.CatStatPlugin;
import benten.cat.stat.model.TmHitRateModel;
import benten.core.model.BentenXliff;
import blanco.xliff.valueobject.BlancoXliffAltTrans;
import blanco.xliff.valueobject.BlancoXliffTransUnit;

/**
 * 翻訳メモリー・ヒット率取得ハンドラー。
 * <p>
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳統計取得機能: 翻訳メモリー・ヒット率ビュー」に対応します。
 *
 * @author KASHIHARA Shinji
 */
public class ShowTmHitRateHandler extends AbstractStatHandler<TmHitRateModel> {

	@Override
	protected TmHitRateModel processFile(final File file) throws IOException, SAXException {
		final TmHitRateModel model = new TmHitRateModel();
		model.setFile(file);
		final BentenXliff xliff = BentenXliff.loadInstance(file);
		for (final BlancoXliffTransUnit unit : xliff.getAllTransUnitList()) {
			final List<BlancoXliffAltTrans> altTransList = unit.getAltTransList();
			setModel(altTransList, model);
		}
		return model;
	}

	/**
	 * モデルの値をセット。
	 * @param altTransList alt-trans リスト
	 * @param model モデル
	 */
	protected void setModel(final List<BlancoXliffAltTrans> altTransList, final TmHitRateModel model) {
		int max = 0;
		for (final BlancoXliffAltTrans altTrans : altTransList) {
			try {
				final int quality = Integer.parseInt(altTrans.getMatchQuality().replace("%", "").trim()); //$NON-NLS-1$ //$NON-NLS-2$
				if (quality > max) {
					max = quality;
				}
			} catch (final RuntimeException e) {
				CatStatPlugin.getDefault().log(e);
			}
		}
		if (max >= 100) {
			model.setMatch100(model.getMatch100() + 1);
		} else if (max >= 95) {
			model.setMatch95(model.getMatch95() + 1);
		} else if (max >= 85) {
			model.setMatch85(model.getMatch85() + 1);
		} else if (max >= 75) {
			model.setMatch75(model.getMatch75() + 1);
		} else {
			model.setMatchUnder75(model.getMatchUnder75() + 1);
		}
	}
}
