/*******************************************************************************
 * Copyright (c) 2009-2010 IGA Tosiki.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.filter.core;

import java.io.File;
import java.io.IOException;

import benten.core.model.HelpTransUnitId;
import benten.twa.process.BentenProcessResultInfo;
import blanco.xliff.valueobject.BlancoXliff;

/**
 * Benten TWA のフィルター・インタフェース。
 * @author IGA Tosiki
 */
public interface BentenTwaFilterEngine {
	/**
	 * 与えられたファイルを処理できるかどうか判定します。
	 * @param file 判定対象ファイル。
	 * @return 処理できるなら true。処理できない場合は false。
	 */
	boolean canProcess(final File file);

	/**
	 * ソースから XLIFF を抽出。
	 * 
	 * <UL>
	 * <LI>このメソッドは ソース -> XLIFF で利用されます。
	 * </UL>
	 * 
	 * TODO id は引数に積むべきではない可能性があります。
	 * 
	 * @param sourceFile 変換元ファイル
	 * @param xliff XLIFF オブジェクト。
	 * @param id trans-unit の id 属性モデル
	 * @param resultInfo 翻訳結果情報
	 * @throws IOException 入出力例外が発生した場合
	 */
	void extractXliff(final File sourceFile, final BlancoXliff xliff, final HelpTransUnitId id,
			final BentenProcessResultInfo resultInfo) throws IOException;

	/**
	 * ソースと XLIFF をマージ。
	 * 
	 * <UL>
	 * <LI>このメソッドは XLIFF -> ソースとマージで利用されます。
	 * </UL>
	 * 
	 * TODO こちらは XLIFF が File 渡しだが、これでは統一感がありません。
	 * 
	 * @param sourceFile 入力となるソース・ファイル
	 * @param xliff 入力となる XLIFF
	 * @return 出力となる XLIFF 内容が反映後の byte 配列
	 * @param resultInfo 翻訳結果情報
	 * @throws IOException 入出力例外が発生した場合
	 */
	byte[] mergeXliff(final File sourceFile, final BlancoXliff xliff, final BentenProcessResultInfo resultInfo)
			throws IOException;
}
