/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.ui.viewers.messages;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * XLIFF エディターの翻訳単位タブに表示するビューアーのためのメッセージ。
 *
 * リソースバンドル定義: [TransUnitViewerMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class TransUnitViewerMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * TransUnitViewerMessagesクラスのコンストラクタ。
     *
     * 基底名[TransUnitViewerMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public TransUnitViewerMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/ui/viewers/messages/TransUnitViewerMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * TransUnitViewerMessagesクラスのコンストラクタ。
     *
     * 基底名[TransUnitViewerMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public TransUnitViewerMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/ui/viewers/messages/TransUnitViewerMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * TransUnitViewerMessagesクラスのコンストラクタ。
     *
     * 基底名[TransUnitViewerMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public TransUnitViewerMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/ui/viewers/messages/TransUnitViewerMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.TransUnit.List]
     *
     * [Translation Unit List] (en)<br>
     * [翻訳単位リスト] (ja)<br>
     *
     * @return key[Label.TransUnit.List]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelTransUnitList() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translation Unit List";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.TransUnit.List");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.State_of_Filter]
     *
     * [Filtere&amp;d State:] (en)<br>
     * [フィルターする状態(&amp;D):] (ja)<br>
     *
     * @return key[Label.State_of_Filter]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelStateOfFilter() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Filtere&d State:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.State_of_Filter");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.Filter.None]
     *
     * [none] (en)<br>
     * [なし] (ja)<br>
     *
     * @return key[Label.Filter.None]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelFilterNone() {
        // 初期値として定義書の値を利用します。
        String strFormat = "none";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.Filter.None");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.ListTitle.State]
     *
     * [State] (en)<br>
     * [状態] (ja)<br>
     *
     * @return key[Label.ListTitle.State]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelListTitleState() {
        // 初期値として定義書の値を利用します。
        String strFormat = "State";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.ListTitle.State");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.ListTitle.Source]
     *
     * [Source] (en)<br>
     * [ソース] (ja)<br>
     *
     * @return key[Label.ListTitle.Source]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelListTitleSource() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Source";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.ListTitle.Source");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.ListTitle.Target]
     *
     * [Target] (en)<br>
     * [ターゲット] (ja)<br>
     *
     * @return key[Label.ListTitle.Target]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelListTitleTarget() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Target";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.ListTitle.Target");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.Group.TransUnit]
     *
     * [Translation Unit] (en)<br>
     * [翻訳単位] (ja)<br>
     *
     * @return key[Label.Group.TransUnit]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelGroupTransUnit() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translation Unit";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.Group.TransUnit");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.ID]
     *
     * [ID:] (en)<br>
     * [ID:] (ja)<br>
     *
     * @return key[Label.ID]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelId() {
        // 初期値として定義書の値を利用します。
        String strFormat = "ID:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.ID");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.State]
     *
     * [&amp;State:] (en)<br>
     * [状態(&amp;S):] (ja)<br>
     *
     * @return key[Label.State]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelState() {
        // 初期値として定義書の値を利用します。
        String strFormat = "&State:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.State");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.OutOfTranslation]
     *
     * [Non-Translatable(&amp;I)] (en)<br>
     * [翻訳対象外(&amp;I)] (ja)<br>
     *
     * @return key[Label.OutOfTranslation]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelOutOfTranslation() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Non-Translatable(&I)";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.OutOfTranslation");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.ApplyToTM]
     *
     * [Apply to T&amp;M] (en)<br>
     * [TM に反映する(&amp;M)] (ja)<br>
     *
     * @return key[Label.ApplyToTM]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelApplyToTM() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Apply to T&M";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.ApplyToTM");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.Source]
     *
     * [Source:] (en)<br>
     * [ソース:] (ja)<br>
     *
     * @return key[Label.Source]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelSource() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Source:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.Source");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.Selected.AltTrans.Source]
     *
     * [Source of the selected alternate translation:] (en)<br>
     * [選択された代替翻訳のソース:] (ja)<br>
     *
     * @return key[Label.Selected.AltTrans.Source]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelSelectedAltTransSource() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Source of the selected alternate translation:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.Selected.AltTrans.Source");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.Target]
     *
     * [Tar&amp;get:] (en)<br>
     * [ターゲット(&amp;G):] (ja)<br>
     *
     * @return key[Label.Target]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelTarget() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Tar&get:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.Target");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.Selected.AltTrans.Target]
     *
     * [Target of the selected alternate translation:] (en)<br>
     * [選択された代替翻訳のターゲット:] (ja)<br>
     *
     * @return key[Label.Selected.AltTrans.Target]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelSelectedAltTransTarget() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Target of the selected alternate translation:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.Selected.AltTrans.Target");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.AltTrans.List]
     *
     * [Alternate Translation Selection &amp;List:] (en)<br>
     * [代替翻訳選択リスト(&amp;L):] (ja)<br>
     *
     * @return key[Label.AltTrans.List]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelAltTransList() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Alternate Translation Selection &List:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.AltTrans.List");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.AltTrans.Title.Origin]
     *
     * [Origin] (en)<br>
     * [起源] (ja)<br>
     *
     * @return key[Label.AltTrans.Title.Origin]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelAltTransTitleOrigin() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Origin";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.AltTrans.Title.Origin");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.AltTrans.Title.Quality]
     *
     * [Quality] (en)<br>
     * [品質] (ja)<br>
     *
     * @return key[Label.AltTrans.Title.Quality]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelAltTransTitleQuality() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Quality";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.AltTrans.Title.Quality");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.AltTrans.Title.Source]
     *
     * [Source] (en)<br>
     * [ソース] (ja)<br>
     *
     * @return key[Label.AltTrans.Title.Source]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelAltTransTitleSource() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Source";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.AltTrans.Title.Source");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.AltTrans.Title.Target]
     *
     * [Target] (en)<br>
     * [ターゲット] (ja)<br>
     *
     * @return key[Label.AltTrans.Title.Target]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelAltTransTitleTarget() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Target";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.AltTrans.Title.Target");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.Note.List]
     *
     * [N&amp;otes List:] (en)<br>
     * [ノート・リスト(&amp;O):] (ja)<br>
     *
     * @return key[Label.Note.List]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelNoteList() {
        // 初期値として定義書の値を利用します。
        String strFormat = "N&otes List:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.Note.List");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.Note.Title.Translator]
     *
     * [Person in charge] (en)<br>
     * [担当] (ja)<br>
     *
     * @return key[Label.Note.Title.Translator]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelNoteTitleTranslator() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Person in charge";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.Note.Title.Translator");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.Note.Title.Contents]
     *
     * [Contents] (en)<br>
     * [内容] (ja)<br>
     *
     * @return key[Label.Note.Title.Contents]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelNoteTitleContents() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Contents";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.Note.Title.Contents");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.Note.New]
     *
     * [New] (en)<br>
     * [新規] (ja)<br>
     *
     * @return key[Label.Note.New]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelNoteNew() {
        // 初期値として定義書の値を利用します。
        String strFormat = "New";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.Note.New");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.Note.New.Text]
     *
     * [New registration of the notes] (en)<br>
     * [ノートの新規登録] (ja)<br>
     *
     * @return key[Label.Note.New.Text]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelNoteNewText() {
        // 初期値として定義書の値を利用します。
        String strFormat = "New registration of the notes";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.Note.New.Text");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.Note.Edit]
     *
     * [Edit] (en)<br>
     * [編集] (ja)<br>
     *
     * @return key[Label.Note.Edit]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelNoteEdit() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Edit";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.Note.Edit");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.Note.Remove]
     *
     * [Remove] (en)<br>
     * [除去] (ja)<br>
     *
     * @return key[Label.Note.Remove]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelNoteRemove() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Remove";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.Note.Remove");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.Edit.Note]
     *
     * [Edit Notes] (en)<br>
     * [ノートの編集] (ja)<br>
     *
     * @return key[Label.Edit.Note]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelEditNote() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Edit Notes";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.Edit.Note");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.JoinToNextTransUnit]
     *
     * [Concatenate the next translation unit(&amp;J)] (en)<br>
     * [次の翻訳単位と結合(&amp;J)] (ja)<br>
     *
     * @return key[Label.JoinToNextTransUnit]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelJoinToNextTransUnit() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Concatenate the next translation unit(&J)";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.JoinToNextTransUnit");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.Prev.TransUnit]
     *
     * [Previous Translation &amp;Unit] (en)<br>
     * [前の翻訳単位(&amp;U)] (ja)<br>
     *
     * @return key[Label.Prev.TransUnit]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelPrevTransUnit() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Previous Translation &Unit";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.Prev.TransUnit");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.Next.TransUnit]
     *
     * [Nex&amp;t Translation Unit] (en)<br>
     * [次の翻訳単位(&amp;T)] (ja)<br>
     *
     * @return key[Label.Next.TransUnit]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelNextTransUnit() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Nex&t Translation Unit";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.Next.TransUnit");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.Prev.AltTrans]
     *
     * [Pre&amp;vious Alternate Translation] (en)<br>
     * [前の代替翻訳(&amp;V)] (ja)<br>
     *
     * @return key[Label.Prev.AltTrans]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelPrevAltTrans() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Pre&vious Alternate Translation";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.Prev.AltTrans");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.Next.AltTrans]
     *
     * [Ne&amp;xt Alternate Translation] (en)<br>
     * [次の代替翻訳(&amp;X)] (ja)<br>
     *
     * @return key[Label.Next.AltTrans]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelNextAltTrans() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Ne&xt Alternate Translation";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.Next.AltTrans");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Viewer.Title]
     *
     * [Translation Unit] (en)<br>
     * [翻訳単位] (ja)<br>
     *
     * @return key[Viewer.Title]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getViewerTitle() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translation Unit";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Viewer.Title");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.TransUnit.Not.Available]
     *
     * [A translation unit list is not available.] (en)<br>
     * [翻訳単位リストは使用できません。] (ja)<br>
     *
     * @return key[Label.TransUnit.Not.Available]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelTransUnitNotAvailable() {
        // 初期値として定義書の値を利用します。
        String strFormat = "A translation unit list is not available.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.TransUnit.Not.Available");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.Select.All.State]
     *
     * [Select/Deselect All] (en)<br>
     * [すべて選択/解除] (ja)<br>
     *
     * @return key[Label.Select.All.State]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelSelectAllState() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Select/Deselect All";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.Select.All.State");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TransUnitViewerMessages], key[Label.Show.Differences]
     *
     * [Show/Hide Differen&amp;ces] (en)<br>
     * [差の表示/非表示(&amp;C)] (ja)<br>
     *
     * @return key[Label.Show.Differences]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelShowDifferences() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Show/Hide Differen&ces";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.Show.Differences");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
