/*******************************************************************************
 * Copyright (c) 2010  NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.ui.viewers;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;

/**
 * コマンド・スタック委譲基底クラス。
 *
 * <UL>
 * <LI>コンストラクターで指定したコマンド・スタックにすべての処理を委譲します。
 * <LI>EMF の UNDO、REDO をオーバーライドして拡張するために用意されたクラスです。
 * </UL>
 *
 * @author KASHIHARA Shinji
 */
public abstract class CommandStackDelegate implements CommandStack {

	// 委譲先となるコマンド・スタック。
	private final CommandStack commandStack;

	/**
	 * コンストラクター。
	 * @param commandStack コマンド・スタック。
	 */
	public CommandStackDelegate(final CommandStack commandStack) {
		this.commandStack = commandStack;
	}

	/**
	 * {@inheritDoc}
	 */
	public void addCommandStackListener(final CommandStackListener commandstacklistener) {
		commandStack.addCommandStackListener(commandstacklistener);
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean canRedo() {
		return commandStack.canRedo();
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean canUndo() {
		return commandStack.canUndo();
	}

	/**
	 * {@inheritDoc}
	 */
	public void execute(final Command command) {
		commandStack.execute(command);
	}

	/**
	 * {@inheritDoc}
	 */
	public void flush() {
		commandStack.flush();
	}

	/**
	 * {@inheritDoc}
	 */
	public Command getMostRecentCommand() {
		return commandStack.getMostRecentCommand();
	}

	/**
	 * {@inheritDoc}
	 */
	public Command getRedoCommand() {
		return commandStack.getRedoCommand();
	}

	/**
	 * {@inheritDoc}
	 */
	public Command getUndoCommand() {
		return commandStack.getUndoCommand();
	}

	/**
	 * {@inheritDoc}
	 */
	public void redo() {
		commandStack.redo();
	}

	/**
	 * {@inheritDoc}
	 */
	public void removeCommandStackListener(final CommandStackListener commandstacklistener) {
		commandStack.removeCommandStackListener(commandstacklistener);
	}

	/**
	 * {@inheritDoc}
	 */
	public void undo() {
		commandStack.undo();
	}
}
