/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.filter.wizards;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import benten.twa.filter.messages.BentenExportHtmlMessages;
import benten.twa.ui.wizards.AbstractWorkflowWellcomeWizardPage;

/**
 * 翻訳成果のエクスポート
 *
 * <pre>
 * 翻訳成果物をプロジェクトからエクスポートします。
 *   1.  XLIFF とインポートされた翻訳対象物をもちいて、翻訳成果物をエクスポートします。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳対象物－翻訳中間形式変換機能: HTMLエクスポート機能」に対応します。
 *
 * @author YAMAMOTO Koji
 */
public class ExportHtmlWizardPage extends AbstractWorkflowWellcomeWizardPage {
	/**
	 * HTMLエクスポート機能のためのメッセージ。
	 */
	protected static final BentenExportHtmlMessages fMsg = new BentenExportHtmlMessages();

	/**
	 * コンストラクター。
	 */
	protected ExportHtmlWizardPage() {
		setTitle(fMsg.getWizardPageTitle());
		setDescription(fMsg.getWizardPageDescription());
	}

	@Override
	public void createContent(final Composite composite) {
		final Label label = new Label(composite, SWT.NULL);
		label.setText(fMsg.getWizardPageLabel1());
	}
}
