/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.cat.status;

import java.io.File;

import benten.ui.UiStatus;

/**
 * 状態をダイアログとハンドラーで共用するためのクラス。
 */
public class BentenApplyExistentTranslationStatus extends UiStatus {
    /**
     * 適用元ディレクトリー。
     *
     * フィールド: [fromDir]。
     */
    private File fFromDir;

    /**
     * 適用先ディレクトリー。
     *
     * フィールド: [toDir]。
     */
    private File fToDir;

    /**
     * テンポラリ・ディレクトリー。
     *
     * フィールド: [tmpDir]。
     */
    private File fTmpDir;

    /**
     * ホワイトスペースを無視するかどうか。
     *
     * フィールド: [ignoreWhitespaceTmReference]。
     * デフォルト: [false]。
     */
    private boolean fIgnoreWhitespaceTmReference = false;

    /**
     * ニーモニック・キーを無視するかどうか。
     *
     * フィールド: [ignoreMnemonicKeyTmReference]。
     * デフォルト: [false]。
     */
    private boolean fIgnoreMnemonicKeyTmReference = false;

    /**
     * フィールド [fromDir] の値を設定します。
     *
     * フィールドの説明: [適用元ディレクトリー。]。
     *
     * @param argFromDir フィールド[fromDir]に設定する値。
     */
    public void setFromDir(final File argFromDir) {
        fFromDir = argFromDir;
    }

    /**
     * フィールド [fromDir] の値を取得します。
     *
     * フィールドの説明: [適用元ディレクトリー。]。
     *
     * @return フィールド[fromDir]から取得した値。
     */
    public File getFromDir() {
        return fFromDir;
    }

    /**
     * フィールド [toDir] の値を設定します。
     *
     * フィールドの説明: [適用先ディレクトリー。]。
     *
     * @param argToDir フィールド[toDir]に設定する値。
     */
    public void setToDir(final File argToDir) {
        fToDir = argToDir;
    }

    /**
     * フィールド [toDir] の値を取得します。
     *
     * フィールドの説明: [適用先ディレクトリー。]。
     *
     * @return フィールド[toDir]から取得した値。
     */
    public File getToDir() {
        return fToDir;
    }

    /**
     * フィールド [tmpDir] の値を設定します。
     *
     * フィールドの説明: [テンポラリ・ディレクトリー。]。
     *
     * @param argTmpDir フィールド[tmpDir]に設定する値。
     */
    public void setTmpDir(final File argTmpDir) {
        fTmpDir = argTmpDir;
    }

    /**
     * フィールド [tmpDir] の値を取得します。
     *
     * フィールドの説明: [テンポラリ・ディレクトリー。]。
     *
     * @return フィールド[tmpDir]から取得した値。
     */
    public File getTmpDir() {
        return fTmpDir;
    }

    /**
     * フィールド [ignoreWhitespaceTmReference] の値を設定します。
     *
     * フィールドの説明: [ホワイトスペースを無視するかどうか。]。
     *
     * @param argIgnoreWhitespaceTmReference フィールド[ignoreWhitespaceTmReference]に設定する値。
     */
    public void setIgnoreWhitespaceTmReference(final boolean argIgnoreWhitespaceTmReference) {
        fIgnoreWhitespaceTmReference = argIgnoreWhitespaceTmReference;
    }

    /**
     * フィールド [ignoreWhitespaceTmReference] の値を取得します。
     *
     * フィールドの説明: [ホワイトスペースを無視するかどうか。]。
     * デフォルト: [false]。
     *
     * @return フィールド[ignoreWhitespaceTmReference]から取得した値。
     */
    public boolean getIgnoreWhitespaceTmReference() {
        return fIgnoreWhitespaceTmReference;
    }

    /**
     * フィールド [ignoreMnemonicKeyTmReference] の値を設定します。
     *
     * フィールドの説明: [ニーモニック・キーを無視するかどうか。]。
     *
     * @param argIgnoreMnemonicKeyTmReference フィールド[ignoreMnemonicKeyTmReference]に設定する値。
     */
    public void setIgnoreMnemonicKeyTmReference(final boolean argIgnoreMnemonicKeyTmReference) {
        fIgnoreMnemonicKeyTmReference = argIgnoreMnemonicKeyTmReference;
    }

    /**
     * フィールド [ignoreMnemonicKeyTmReference] の値を取得します。
     *
     * フィールドの説明: [ニーモニック・キーを無視するかどうか。]。
     * デフォルト: [false]。
     *
     * @return フィールド[ignoreMnemonicKeyTmReference]から取得した値。
     */
    public boolean getIgnoreMnemonicKeyTmReference() {
        return fIgnoreMnemonicKeyTmReference;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.twa.cat.status.BentenApplyExistentTranslationStatus[");
        buf.append("fromDir=" + fFromDir);
        buf.append(",toDir=" + fToDir);
        buf.append(",tmpDir=" + fTmpDir);
        buf.append(",ignoreWhitespaceTmReference=" + fIgnoreWhitespaceTmReference);
        buf.append(",ignoreMnemonicKeyTmReference=" + fIgnoreMnemonicKeyTmReference);
        buf.append("]");
        return buf.toString();
    }
}
