/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.tmx.wizards;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import benten.twa.tmx.messages.BentenExtractTmxFragmentMessages;
import benten.twa.ui.wizards.AbstractWorkflowWellcomeWizardPage;

/**
 * TMX フラグメントの抽出
 *
 * <pre>
 * XLIFF フラグメントから、TMX フラグメントを抽出します。
 *   1.  XLIFF から翻訳単位を抽出して TMX を作成します。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳メモリー断片抽出・マージ機能: TMXフラグメント抽出機能」に対応します。
 *
 * @author YAMAMOTO Koji
 */
public class ExtractTmxFragmentWizardPage extends AbstractWorkflowWellcomeWizardPage {
	/**
	 * TMXフラグメント抽出機能のためのメッセージ。
	 */
	protected static final BentenExtractTmxFragmentMessages fMsg = new BentenExtractTmxFragmentMessages();

	/**
	 * コンストラクター。
	 */
	protected ExtractTmxFragmentWizardPage() {
		setTitle(fMsg.getWizardPageTitle());
		setDescription(fMsg.getWizardPageDescription());
	}

	@Override
	public void createContent(final Composite composite) {
		final Label label = new Label(composite, SWT.WRAP);
		label.setText(fMsg.getWizardPageLabel1());
		final GridData gridDate = new GridData(GridData.FILL_BOTH);
		label.setLayoutData(gridDate);
	}
}
