/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui.dialogs;

import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Shell;

import benten.ui.dialogs.messages.ResourceSelectionDialogMessages;

/**
 * リソース・フォルダー選択ダイアログ。
 *
 * <UL>
 * <LI>ワークスペース以下のリソース・フォルダーを選択する際に利用されるダイアログです。
 * </UL>
 *
 * @author KASHIHARA Shinji
 */
public class ResourceFolderSelectionDialog extends AbstractResourceSelectionDialog {

	/**
	 * リソース * 選択ダイアログのためのメッセージ。
	 */
	protected static final ResourceSelectionDialogMessages fMsg = new ResourceSelectionDialogMessages();

	/**
	 * コンストラクター。
	 * @param parentShell 親シェル
	 * @param resources リソース
	 */
	public ResourceFolderSelectionDialog(final Shell parentShell, final IResource[] resources) {
		super(parentShell, resources);
		setTitle(fMsg.getMsg011());
		setMessage(fMsg.getMsg012());
	}

	@Override
	protected boolean acceptSelection(final IResource resource) {
		if (resource == null) {
			// CentOS 5 の Java 実行環境 + Eclipse において、resource が null で与えられる場合があります。
			// これを回避すべく、null が与えられた場合には false を戻して処理中断します。
			return false;
		}

		return resource.getType() == IResource.FOLDER;
	}
}
