/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.xliff.wizards;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import benten.twa.ui.wizards.AbstractWorkflowWellcomeWizardPage;
import benten.twa.xliff.messages.BentenExtractXliffFragmentMessages;

/**
 * XLIFF フラグメントの抽出
 *
 * <pre>
 * XLIFF から XLIFF フラグメントを抽出します。
 *   1.  XLIFF から所定の条件に合う翻訳単位を抽出して XLIFF フラグメントを作成します。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳中間形式断片抽出・マージ機能: XLIFFフラグメント抽出機能」に対応します。
 *
 * @author YAMAMOTO Koji
 */
public class ExtractXliffFragmentWizardPage extends AbstractWorkflowWellcomeWizardPage {
	/**
	 * XLIFF フラグメント抽出機能のためのメッセージ。
	 */
	protected static final BentenExtractXliffFragmentMessages fMsg = new BentenExtractXliffFragmentMessages();

	/**
	 * コンストラクター。
	 */
	protected ExtractXliffFragmentWizardPage() {
		setTitle(fMsg.getWizardPageTitle());
		setDescription(fMsg.getWizardPageDescription());
	}

	@Override
	public void createContent(final Composite composite) {
		final Label label = new Label(composite, SWT.WRAP);
		label.setText(fMsg.getWizardPageLabel1());
	}
}
