/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.stat.views;

import org.eclipse.swt.SWT;

import benten.cat.stat.model.WordCountModel;
import benten.cat.stat.views.messages.WordCountViewMessages;
import benten.ui.views.AutoColumnWidthTableViewer;
import benten.ui.views.TableLabelProvider;

/**
 * ワード数ビュー。
 * <p>
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳統計取得機能: ワード数ビュー」に対応します。
 *
 * @author KASHIHARA Shinji
 */
public class WordCountView extends AbstractStatView {
	/**
	 * ワード数ビューのためのメッセージ。
	 */
	protected static final WordCountViewMessages fMsg = new WordCountViewMessages();

	@Override
	protected void createTableViewer(final AutoColumnWidthTableViewer viewer) {
		viewer.addColumn(fMsg.getResource(), 15);
		viewer.addColumn(fMsg.getWordCount(), 7, SWT.RIGHT);

		viewer.setLabelProvider(new TableLabelProvider() {
			public String getColumnText(final Object obj, final int index) {
				final WordCountModel entry = (WordCountModel) obj;
				switch (index) {
				case 0:
					return entry.getFile().toString();
				case 1:
					return String.valueOf(entry.getWordCount());
				}
				return getText(obj);
			}
		});
	}
}
