/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui.views;

import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.ViewPart;

import benten.ui.UiPlugin;

/**
 * コピーをサポートするテーブル・ビュー。
 *
 * <UL>
 * <LI>テーブル・ビューでコピーをサポートする場合の基底クラスです。
 * </UL>
 *
 * @author YAMAMOTO Koji
 * @author KASHIHARA Shinji
 */
public abstract class CopySupportTableView extends ViewPart {

	/** テーブル・ビューアー */
	private AutoColumnWidthTableViewer viewer;

	/** クリップボード */
	private Clipboard clipboard;

	@Override
	public void createPartControl(final Composite parent) {
		viewer = new AutoColumnWidthTableViewer(parent);
		createTableViewer(viewer);

		viewer.addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(final DoubleClickEvent event) {
				final IEditorPart editor = UiPlugin.getActivePage().getActiveEditor();
				if (editor == null) {
					return;
				}
				final ISourceViewer targetViewer = (ISourceViewer) editor.getAdapter(ISourceViewer.class);
				if (targetViewer == null) {
					return;
				}
				final StyledText widget = targetViewer.getTextWidget();
				final StringBuilder text = new StringBuilder(widget.getText());
				final Point targetSel = widget.getSelectionRange();

				final IStructuredSelection tableSel = (IStructuredSelection) event.getSelection();
				final String replacement = getDoubleClickString(tableSel.getFirstElement());

				if (targetSel.y == 0) {
					text.insert(targetSel.x, replacement);
				} else {
					text.replace(targetSel.x, targetSel.x + targetSel.y, replacement);
				}
				widget.setText(text.toString());
				widget.setSelection(targetSel.x, targetSel.x + replacement.length());
				widget.setFocus();
			}
		});
	}

	/**
	 * テーブル・ビューアーを作成するテンプレート・メソッド。
	 * @param viewer テーブル・ビューアー
	 */
	public abstract void createTableViewer(AutoColumnWidthTableViewer viewer);

	/**
	 * ダブルクリックされた時に取得する文字列。
	 * @param element 要素。
	 * @return 文字列。
	 */
	protected abstract String getDoubleClickString(final Object element);

	/**
	 * クリップボードの取得。
	 * @return クリップボード
	 */
	public Clipboard getClipBoard() {
		if (clipboard == null) {
			clipboard = new Clipboard(getSite().getShell().getDisplay());
		}
		return clipboard;
	}

	@Override
	public void dispose() {
		if (clipboard != null) {
			clipboard.dispose();
		}
		super.dispose();
	}

	@Override
	public void setFocus() {
		viewer.getControl().setFocus();
	}

	/**
	 * テーブル・ビューアーの取得。
	 * @return テーブル・ビューアー
	 */
	public TableViewer getTableViewer() {
		return viewer;
	}
}
