/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui;

import org.eclipse.core.runtime.IStatus;

/**
 * UI ステータス例外。
 *
 * <UL>
 * <LI>{@link UiStatus} を保持する UI 用の例外クラスです。
 * </UL>
 *
 * @author KASHIHARA Shinji
 */
@SuppressWarnings("serial")
public class UiStatusException extends Exception {

	/** UI ステータス */
	private final UiStatus status;

	/**
	 * コンストラクター。
	 * @param message メッセージ
	 */
	public UiStatusException(final String message) {
		this(IStatus.ERROR, message);
	}

	/**
	 * コンストラクター。
	 * @param severity 重大度
	 * @param message メッセージ
	 */
	public UiStatusException(final int severity, final String message) {
		super(message);
		status = new UiStatus(severity, message);
	}

	/**
	 * ステータスを取得。
	 * @return ステータス
	 */
	public UiStatus getStatus() {
		return status;
	}
}
