/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.glossary.ui.preference.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * Benten 用語集設定のためのメッセージ。
 *
 * リソースバンドル定義: [CatGlossaryUiPreferencePageMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class CatGlossaryUiPreferencePageMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * CatGlossaryUiPreferencePageMessagesクラスのコンストラクタ。
     *
     * 基底名[CatGlossaryUiPreferencePageMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public CatGlossaryUiPreferencePageMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/glossary/ui/preference/messages/CatGlossaryUiPreferencePageMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * CatGlossaryUiPreferencePageMessagesクラスのコンストラクタ。
     *
     * 基底名[CatGlossaryUiPreferencePageMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public CatGlossaryUiPreferencePageMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/glossary/ui/preference/messages/CatGlossaryUiPreferencePageMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * CatGlossaryUiPreferencePageMessagesクラスのコンストラクタ。
     *
     * 基底名[CatGlossaryUiPreferencePageMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public CatGlossaryUiPreferencePageMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/glossary/ui/preference/messages/CatGlossaryUiPreferencePageMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[CatGlossaryUiPreferencePageMessages], key[Label.0]
     *
     * [Glossary Engine:] (en)<br>
     * [用語集エンジン:] (ja)<br>
     *
     * @return key[Label.0]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel0() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Glossary Engine:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.0");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatGlossaryUiPreferencePageMessages], key[Label.1]
     *
     * [Glossary Data (TSV) Location] (en)<br>
     * [使用する用語集データ(TSV)のロケーション] (ja)<br>
     *
     * @return key[Label.1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel1() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Glossary Data (TSV) Location";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.1");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatGlossaryUiPreferencePageMessages], key[Label.2]
     *
     * [Glossary Data (TSV) for plug-in] (en)<br>
     * [プラグイン組み込み用語集データ(TSV)] (ja)<br>
     *
     * @return key[Label.2]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel2() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Glossary Data (TSV) for plug-in";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.2");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatGlossaryUiPreferencePageMessages], key[Label.3]
     *
     * [Next Location:] (en)<br>
     * [次のロケーション:] (ja)<br>
     *
     * @return key[Label.3]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel3() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Next Location:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.3");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatGlossaryUiPreferencePageMessages], key[Dlg.Error.0]
     *
     * [Please specify the glossary data location.] (en)<br>
     * [用語集データ・ロケーションを指定してください。] (ja)<br>
     *
     * @return key[Dlg.Error.0]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDlgError0() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Please specify the glossary data location.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Dlg.Error.0");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatGlossaryUiPreferencePageMessages], key[Dlg.Error.1]
     *
     * [Input error] (en)<br>
     * [入力エラー] (ja)<br>
     *
     * @return key[Dlg.Error.1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDlgError1() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Input error";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Dlg.Error.1");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatGlossaryUiPreferencePageMessages], key[Dlg.Error.2]
     *
     * [The specified glossary data directory does not exist.] (en)<br>
     * [指定された用語集データ・ディレクトリーは存在しません。] (ja)<br>
     *
     * @return key[Dlg.Error.2]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDlgError2() {
        // 初期値として定義書の値を利用します。
        String strFormat = "The specified glossary data directory does not exist.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Dlg.Error.2");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatGlossaryUiPreferencePageMessages], key[Dlg.Error.3]
     *
     * [Input error] (en)<br>
     * [入力エラー] (ja)<br>
     *
     * @return key[Dlg.Error.3]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDlgError3() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Input error";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Dlg.Error.3");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatGlossaryUiPreferencePageMessages], key[Dlg.Error.4]
     *
     * [Please setup the valid glossary data preferences: {0}] (en)<br>
     * [有効な用語集データ設定を行ってください。: {0}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[Dlg.Error.4]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDlgError4(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Please setup the valid glossary data preferences: {0}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Dlg.Error.4");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[CatGlossaryUiPreferencePageMessages], key[Dlg.Error.5]
     *
     * [Failed to load the glossary data.] (en)<br>
     * [用語集データのロードに失敗しました] (ja)<br>
     *
     * @return key[Dlg.Error.5]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDlgError5() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Failed to load the glossary data.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Dlg.Error.5");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
