/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.validation.validator.messages;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * 検証メッセージを追加するための翻訳リポーターのためのメッセージ。
 *
 * リソースバンドル定義: [TranslationValidationReporterMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class TranslationValidationReporterMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * TranslationValidationReporterMessagesクラスのコンストラクタ。
     *
     * 基底名[TranslationValidationReporterMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public TranslationValidationReporterMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/validation/validator/messages/TranslationValidationReporterMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * TranslationValidationReporterMessagesクラスのコンストラクタ。
     *
     * 基底名[TranslationValidationReporterMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public TranslationValidationReporterMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/validation/validator/messages/TranslationValidationReporterMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * TranslationValidationReporterMessagesクラスのコンストラクタ。
     *
     * 基底名[TranslationValidationReporterMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public TranslationValidationReporterMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/validation/validator/messages/TranslationValidationReporterMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[TranslationValidationReporterMessages], key[add_GroupName]
     *
     * [Translation Validation Group] (en)<br>
     * [翻訳検証グループ] (ja)<br>
     *
     * @return key[add_GroupName]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getAddGroupName() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Translation Validation Group";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("add_GroupName");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
