/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.stat.views;

import org.eclipse.swt.SWT;

import benten.cat.stat.model.TranslationRateModel;
import benten.cat.stat.views.messages.TranslationRateViewMessages;
import benten.ui.views.AutoColumnWidthTableViewer;
import benten.ui.views.TableLabelProvider;

/**
 * 翻訳率ビュー。
 * <p>
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳統計取得機能: 翻訳率ビュー」に対応します。
 *
 * @author KASHIHARA Shinji
 */
public class TranslationRateView extends AbstractStatView {
	/**
	 * 翻訳率ビューのためのメッセージ。
	 */
	protected static final TranslationRateViewMessages fMsg = new TranslationRateViewMessages();

	@Override
	protected void createTableViewer(final AutoColumnWidthTableViewer viewer) {
		viewer.addColumn(fMsg.getResource(), 15);
		viewer.addColumn(fMsg.getTransUnit(), 6, SWT.RIGHT);
		viewer.addColumn(fMsg.getUnTranslate(), 6, SWT.RIGHT);
		viewer.addColumn(fMsg.getUnTranslateRate(), 6, SWT.RIGHT);
		viewer.addColumn(fMsg.getNotTranslated(), 6, SWT.RIGHT);
		viewer.addColumn(fMsg.getNotTranslatedRate(), 6, SWT.RIGHT);
		viewer.addColumn(fMsg.getTranslating(), 6, SWT.RIGHT);
		viewer.addColumn(fMsg.getTranslatingRate(), 6, SWT.RIGHT);
		viewer.addColumn(fMsg.getTranslated(), 6, SWT.RIGHT);
		viewer.addColumn(fMsg.getTranslatedRate(), 6, SWT.RIGHT);

		viewer.setLabelProvider(new TableLabelProvider() {
			public String getColumnText(final Object element, final int columnIndex) {
				final TranslationRateModel entry = (TranslationRateModel) element;
				switch (columnIndex) {
				case 0:
					return entry.getFile().toString();
				case 1:
					return String.valueOf(entry.getTransUnit());
				case 2:
					return String.valueOf(entry.getUntranslate());
				case 3:
					return entry.getUntranslateRate() + "%"; //$NON-NLS-1$
				case 4:
					return String.valueOf(entry.getNottranslated());
				case 5:
					return entry.getNottranslatedRate() + "%"; //$NON-NLS-1$
				case 6:
					return String.valueOf(entry.getWorking());
				case 7:
					return entry.getWorkingRate() + "%"; //$NON-NLS-1$
				case 8:
					return String.valueOf(entry.getTranslated());
				case 9:
					return entry.getTranslatedRate() + "%"; //$NON-NLS-1$
				}
				return getText(element);
			}
		});
	}
}
