/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.tm.ui.preference.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * Benten TM 設定のためのメッセージ。
 *
 * リソースバンドル定義: [CatTmUiPreferencePageMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class CatTmUiPreferencePageMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * CatTmUiPreferencePageMessagesクラスのコンストラクタ。
     *
     * 基底名[CatTmUiPreferencePageMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public CatTmUiPreferencePageMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/tm/ui/preference/messages/CatTmUiPreferencePageMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * CatTmUiPreferencePageMessagesクラスのコンストラクタ。
     *
     * 基底名[CatTmUiPreferencePageMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public CatTmUiPreferencePageMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/tm/ui/preference/messages/CatTmUiPreferencePageMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * CatTmUiPreferencePageMessagesクラスのコンストラクタ。
     *
     * 基底名[CatTmUiPreferencePageMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public CatTmUiPreferencePageMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/tm/ui/preference/messages/CatTmUiPreferencePageMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[CatTmUiPreferencePageMessages], key[Label.0]
     *
     * [TM Engine:] (en)<br>
     * [TM エンジン:] (ja)<br>
     *
     * @return key[Label.0]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel0() {
        // 初期値として定義書の値を利用します。
        String strFormat = "TM Engine:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.0");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatTmUiPreferencePageMessages], key[Label.1]
     *
     * [TMX Location] (en)<br>
     * [使用する TMX のロケーション] (ja)<br>
     *
     * @return key[Label.1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel1() {
        // 初期値として定義書の値を利用します。
        String strFormat = "TMX Location";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.1");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatTmUiPreferencePageMessages], key[Label.2]
     *
     * [TMX for plug-in] (en)<br>
     * [プラグイン組み込み TMX] (ja)<br>
     *
     * @return key[Label.2]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel2() {
        // 初期値として定義書の値を利用します。
        String strFormat = "TMX for plug-in";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.2");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatTmUiPreferencePageMessages], key[Label.3]
     *
     * [Next Location:] (en)<br>
     * [次のロケーション:] (ja)<br>
     *
     * @return key[Label.3]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel3() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Next Location:";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.3");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatTmUiPreferencePageMessages], key[Label.11]
     *
     * [Handling of Space and Newline] (en)<br>
     * [空白や改行の扱い] (ja)<br>
     *
     * @return key[Label.11]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel11() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Handling of Space and Newline";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.11");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatTmUiPreferencePageMessages], key[Label.12]
     *
     * [Ignore white space and newline when &amp;referencing TM] (en)<br>
     * [TM 参照時に空白や改行を無視(&amp;R)] (ja)<br>
     *
     * @return key[Label.12]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel12() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Ignore white space and newline when &referencing TM";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.12");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatTmUiPreferencePageMessages], key[Label.13]
     *
     * [Ignore white space and newline when &amp;extracting TMX] (en)<br>
     * [TMX 抽出時に空白や改行を無視(&amp;E)] (ja)<br>
     *
     * @return key[Label.13]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel13() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Ignore white space and newline when &extracting TMX";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.13");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatTmUiPreferencePageMessages], key[Label.MnemonicKeyGroup]
     *
     * [Handling of Mnemonic Key] (en)<br>
     * [ニーモニック・キーの扱い] (ja)<br>
     *
     * @return key[Label.MnemonicKeyGroup]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelMnemonicKeyGroup() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Handling of Mnemonic Key";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.MnemonicKeyGroup");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatTmUiPreferencePageMessages], key[Label.MnemonicKeyIgnoreTmReference]
     *
     * [Ignore mnemonic key when re&amp;ferencing TM] (en)<br>
     * [TM 参照時にニーモニック・キーを無視(&amp;F)] (ja)<br>
     *
     * @return key[Label.MnemonicKeyIgnoreTmReference]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelMnemonicKeyIgnoreTmReference() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Ignore mnemonic key when re&ferencing TM";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.MnemonicKeyIgnoreTmReference");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatTmUiPreferencePageMessages], key[Label.MnemonicKeyIgnoreTmxExtract]
     *
     * [Ignore mnemonic key when ex&amp;tracting TMX] (en)<br>
     * [TMX 抽出時にニーモニック・キーを無視(&amp;T)] (ja)<br>
     *
     * @return key[Label.MnemonicKeyIgnoreTmxExtract]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabelMnemonicKeyIgnoreTmxExtract() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Ignore mnemonic key when ex&tracting TMX";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.MnemonicKeyIgnoreTmxExtract");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatTmUiPreferencePageMessages], key[Dlg.Error.0]
     *
     * [Please specify TMX location.] (en)<br>
     * [TMX ロケーションを指定してください。] (ja)<br>
     *
     * @return key[Dlg.Error.0]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDlgError0() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Please specify TMX location.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Dlg.Error.0");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatTmUiPreferencePageMessages], key[Dlg.Error.1]
     *
     * [Input error] (en)<br>
     * [入力エラー] (ja)<br>
     *
     * @return key[Dlg.Error.1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDlgError1() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Input error";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Dlg.Error.1");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatTmUiPreferencePageMessages], key[Dlg.Error.2]
     *
     * [The specified TMX directory does not exist.] (en)<br>
     * [指定された TMX ディレクトリーは存在しません。] (ja)<br>
     *
     * @return key[Dlg.Error.2]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDlgError2() {
        // 初期値として定義書の値を利用します。
        String strFormat = "The specified TMX directory does not exist.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Dlg.Error.2");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatTmUiPreferencePageMessages], key[Dlg.Error.3]
     *
     * [Input error] (en)<br>
     * [入力エラー] (ja)<br>
     *
     * @return key[Dlg.Error.3]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDlgError3() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Input error";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Dlg.Error.3");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatTmUiPreferencePageMessages], key[Dlg.Error.4]
     *
     * [Please setup the valid TM preferences: {0}] (en)<br>
     * [有効な TM 設定を行ってください。: {0}] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[Dlg.Error.4]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDlgError4(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "Please setup the valid TM preferences: {0}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Dlg.Error.4");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[CatTmUiPreferencePageMessages], key[Dlg.Error.5]
     *
     * [Failed to load the TM.] (en)<br>
     * [TM のロードに失敗しました] (ja)<br>
     *
     * @return key[Dlg.Error.5]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getDlgError5() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Failed to load the TM.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Dlg.Error.5");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
