/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.tm.core;

import java.io.File;
import java.io.IOException;
import java.util.List;

/**
 * Benten TM (翻訳メモリー) エンジンをあらわすインタフェース。
 * 
 * <UL>
 * <LI>TM の処理そのものです。
 * <LI>このインタフェースを実装して、TM エンジンを実装します。
 * <LI>TM エンジンに対応する TM ドライバーを提供することにより、TM エンジンが Benten で有効になります。
 * </UL>
 * 
 * @author IGA Tosiki
 */
public interface BentenTmEngine {
	/**
	 * 翻訳言語を設定。
	 * 
	 * @param source 翻訳元の言語。例: en-US。
	 * @param target 翻訳先の言語。例: ja-JP。
	 */
	void setLang(String source, String target);

	/**
	 * ディレクトリ内の TMX 形式のファイルから TM (翻訳メモリー) をロード。
	 * 
	 * <UL>
	 * <LI>指定されたディレクトリ内の TMX 形式のファイルから TM (翻訳メモリー) をロードします。
	 * <LI>このメソッドを呼ぶと、追加的に TM が構築されます。
	 * </UL>
	 * 
	 * @param dirTmx TMX 形式のファイルが格納されたディレクトリー。
	 * @throws IOException 入出力例外が発生した場合。
	 */
	void loadTmx(File dirTmx) throws IOException;

	/**
	 * TM (翻訳メモリー) のアンロード。
	 * 
	 * <UL>
	 * <LI>このエンジンが保持している TM を破棄します。
	 * </UL>
	 */
	void unload();

	/**
	 * あいまい一致 TM 検索結果のリストを取得。
	 * 
	 * <UL>
	 * <LI>あいまい一致 TM 検索結果のリストを取得します。
	 * </UL>
	 *
	 * @param search ターゲット。
	 * @return あいまい一致 TM 検索結果のリスト。
	 */
	List<BentenTmSearchResult> fuzzySearch(String search);
}
