/*******************************************************************************
 * Copyright (c) 2010  NEC Soft, Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.cat.ui.viewers;

import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

import benten.cat.ui.internal.tabletree.XLIFFMultiPageEditorPart;
import benten.cat.ui.viewers.messages.TransUnitViewerMessages;

/**
 * 翻訳単位リスト・ビュー。
 *
 * <UL>
 * <LI>XLIFF エディターの翻訳単位リストを表示するためのビュー・クラスです。
 * </UL>
 *
 * ★基本設計「翻訳支援機能: 翻訳中間形式エディター機能: 翻訳単位選択」に対応します。<br>
 *
 * @author KASHIHARA Shinji
 */
public class TransUnitListView extends PageBookView {

	/**
	 * XLIFF エディターの翻訳単位タブに表示するビューアーのためのメッセージ。
	 */
	protected static final TransUnitViewerMessages fMsg = new TransUnitViewerMessages();

	@Override
	protected IPage createDefaultPage(final PageBook book) {
		final MessagePage page = new MessagePage();
		page.setMessage(fMsg.getLabelTransUnitNotAvailable());
		initPage(page);
		page.createControl(book);
		return page;
	}

	@Override
	protected PageRec doCreatePage(final IWorkbenchPart part) {
		IPageBookViewPage page = null;
		if (part instanceof XLIFFMultiPageEditorPart) {
			final TransUnitViewer viewer = ((XLIFFMultiPageEditorPart) part).getTransUnitViewer();
			page = new TransUnitListPage(viewer);
		}
		if (page == null) {
			return null;
		}
		initPage(page);
		page.createControl(getPageBook());
		return new PageRec(part, page);
	}

	@Override
	protected void doDestroyPage(final IWorkbenchPart part, final PageRec pageRecord) {
		pageRecord.page.dispose();
	}

	@Override
	protected IWorkbenchPart getBootstrapPart() {
		final IWorkbenchPage page = getSite().getPage();
		if (page != null) {
			final IWorkbenchPart activePart = page.getActivePart();
			return isImportant(activePart) ? activePart : null;
		}
		return null;
	}

	@Override
	protected boolean isImportant(final IWorkbenchPart part) {
		return (part instanceof XLIFFMultiPageEditorPart);
	}
}
