/*******************************************************************************
 * Copyright (c) 2010 IGA Tosiki.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
/*
 * Copyright (C) 2010 IGA Tosiki.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package benten.twa.filter.engine.po;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;

import blanco.commons.util.BlancoStringUtil;

/**
 * PO ファイルを単に書き込むだけのクラスです。文字列リテラルのエスケープ処理すら行ないません。
 * 
 * @author Tosiki Iga
 * @see "http://www.gnu.org/software/hello/manual/gettext/PO-Files.html"
 */
public class SimplePOWriter {
	public static void main(final String[] args) throws IOException {
		List<SimplePOEntry> entryList = new SimplePOReader().process(new FileInputStream("a.po"));

		new SimplePOWriter().process(entryList, new FileOutputStream("a2.po"));
	}

	void process(final List<SimplePOEntry> entryList, final OutputStream outStream) throws IOException {
		final BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outStream, "UTF-8"));
		for (int index = 0; index < entryList.size(); index++) {
			final SimplePOEntry entry = entryList.get(index);
			for (String comment : entry.fCommentList) {
				writer.write("#" + BlancoStringUtil.null2Blank(comment));
				writer.write("\n");
			}

			if ("x-benten-whitespace".equals(BlancoStringUtil.null2Blank(entry.fCommand))) {
				if (index == entryList.size() - 1) {
					// 最終行の場合、強制的な改行付与は抑止しています。
				} else {
					// TODO このような強制的な改行付与は、本来望ましくありません。
					// TODO もとのホワイトスペースを記憶して再現するように改良してください。
					writer.write('\n');
				}
			} else {
				writer.write(BlancoStringUtil.null2Blank(entry.fCommand));
			}

			boolean isFirstLiteral = true;
			for (String literal : entry.fStringLiteralList) {
				if (isFirstLiteral) {
					isFirstLiteral = false;
					writer.write(" ");
				}
				writer.write("\"" + BlancoStringUtil.null2Blank(literal) + "\"");
				writer.write("\n");
			}
		}
		writer.close();
	}
}
