/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.filter.preference.messages;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * 翻訳支援ツール・フィルターのプロパティー・ページのためのメッセージ。
 *
 * リソースバンドル定義: [TwaFilterPropertyPageMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class TwaFilterPropertyPageMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * TwaFilterPropertyPageMessagesクラスのコンストラクタ。
     *
     * 基底名[TwaFilterPropertyPageMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public TwaFilterPropertyPageMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/filter/preference/messages/TwaFilterPropertyPageMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * TwaFilterPropertyPageMessagesクラスのコンストラクタ。
     *
     * 基底名[TwaFilterPropertyPageMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public TwaFilterPropertyPageMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/filter/preference/messages/TwaFilterPropertyPageMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * TwaFilterPropertyPageMessagesクラスのコンストラクタ。
     *
     * 基底名[TwaFilterPropertyPageMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public TwaFilterPropertyPageMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/twa/filter/preference/messages/TwaFilterPropertyPageMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[TwaFilterPropertyPageMessages], key[Label.0]
     *
     * [Show a confirmation dialog when execution completed.] (en)<br>
     * [実行済みの場合の確認ダイアログ表示] (ja)<br>
     *
     * @return key[Label.0]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel0() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Show a confirmation dialog when execution completed.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.0");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TwaFilterPropertyPageMessages], key[Label.1]
     *
     * [I&amp;mport Translation Target] (en)<br>
     * [翻訳対象のインポート(&amp;M)] (ja)<br>
     *
     * @return key[Label.1]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel1() {
        // 初期値として定義書の値を利用します。
        String strFormat = "I&mport Translation Target";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.1");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TwaFilterPropertyPageMessages], key[Label.2]
     *
     * [C&amp;onvert the translation target to XLIFF] (en)<br>
     * [翻訳対象を XLIFF に変換(&amp;O)] (ja)<br>
     *
     * @return key[Label.2]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getLabel2() {
        // 初期値として定義書の値を利用します。
        String strFormat = "C&onvert the translation target to XLIFF";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Label.2");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TwaFilterPropertyPageMessages], key[Msg.001]
     *
     * [&lt;Executed&gt;] (en)<br>
     * [&lt;実行済&gt;] (ja)<br>
     *
     * @return key[Msg.001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg001() {
        // 初期値として定義書の値を利用します。
        String strFormat = "<Executed>";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.001");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TwaFilterPropertyPageMessages], key[Msg.002]
     *
     * [&lt;Unexecuted&gt;] (en)<br>
     * [&lt;未実行&gt;] (ja)<br>
     *
     * @return key[Msg.002]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg002() {
        // 初期値として定義書の値を利用します。
        String strFormat = "<Unexecuted>";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.002");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
