/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.filter.core.valueobject;

/**
 * 処理クラス [BentenConvertToXliffProcess]の入力バリューオブジェクトクラスです。
 */
public class BentenConvertToXliffProcessInput {
    /**
     * verboseモードで動作させるかどうか。
     *
     * フィールド: [verbose]。
     * デフォルト: [false]。
     */
    private boolean fVerbose = false;

    /**
     * 変換元となる HTML が格納されたディレクトリ。
     *
     * フィールド: [sourcedir]。
     */
    private String fSourcedir;

    /**
     * 変換先となる XLIFF を格納するディレクトリ。
     *
     * フィールド: [targetdir]。
     */
    private String fTargetdir;

    /**
     * 翻訳対象 id  を格納します。
     *
     * フィールド: [transtargetid]。
     */
    private String fTranstargetid;

    /**
     * 翻訳元言語
     *
     * フィールド: [transsourcelang]。
     * デフォルト: [en-US]。
     */
    private String fTranssourcelang = "en-US";

    /**
     * 翻訳先言語
     *
     * フィールド: [transtargetlang]。
     * デフォルト: [ja-JP]。
     */
    private String fTranstargetlang = "ja-JP";

    /**
     * フィールド [verbose] の値を設定します。
     *
     * フィールドの説明: [verboseモードで動作させるかどうか。]。
     *
     * @param argVerbose フィールド[verbose]に設定する値。
     */
    public void setVerbose(final boolean argVerbose) {
        fVerbose = argVerbose;
    }

    /**
     * フィールド [verbose] の値を取得します。
     *
     * フィールドの説明: [verboseモードで動作させるかどうか。]。
     * デフォルト: [false]。
     *
     * @return フィールド[verbose]から取得した値。
     */
    public boolean getVerbose() {
        return fVerbose;
    }

    /**
     * フィールド [sourcedir] の値を設定します。
     *
     * フィールドの説明: [変換元となる HTML が格納されたディレクトリ。]。
     *
     * @param argSourcedir フィールド[sourcedir]に設定する値。
     */
    public void setSourcedir(final String argSourcedir) {
        fSourcedir = argSourcedir;
    }

    /**
     * フィールド [sourcedir] の値を取得します。
     *
     * フィールドの説明: [変換元となる HTML が格納されたディレクトリ。]。
     *
     * @return フィールド[sourcedir]から取得した値。
     */
    public String getSourcedir() {
        return fSourcedir;
    }

    /**
     * フィールド [targetdir] の値を設定します。
     *
     * フィールドの説明: [変換先となる XLIFF を格納するディレクトリ。]。
     *
     * @param argTargetdir フィールド[targetdir]に設定する値。
     */
    public void setTargetdir(final String argTargetdir) {
        fTargetdir = argTargetdir;
    }

    /**
     * フィールド [targetdir] の値を取得します。
     *
     * フィールドの説明: [変換先となる XLIFF を格納するディレクトリ。]。
     *
     * @return フィールド[targetdir]から取得した値。
     */
    public String getTargetdir() {
        return fTargetdir;
    }

    /**
     * フィールド [transtargetid] の値を設定します。
     *
     * フィールドの説明: [翻訳対象 id  を格納します。]。
     *
     * @param argTranstargetid フィールド[transtargetid]に設定する値。
     */
    public void setTranstargetid(final String argTranstargetid) {
        fTranstargetid = argTranstargetid;
    }

    /**
     * フィールド [transtargetid] の値を取得します。
     *
     * フィールドの説明: [翻訳対象 id  を格納します。]。
     *
     * @return フィールド[transtargetid]から取得した値。
     */
    public String getTranstargetid() {
        return fTranstargetid;
    }

    /**
     * フィールド [transsourcelang] の値を設定します。
     *
     * フィールドの説明: [翻訳元言語]。
     *
     * @param argTranssourcelang フィールド[transsourcelang]に設定する値。
     */
    public void setTranssourcelang(final String argTranssourcelang) {
        fTranssourcelang = argTranssourcelang;
    }

    /**
     * フィールド [transsourcelang] の値を取得します。
     *
     * フィールドの説明: [翻訳元言語]。
     * デフォルト: [en-US]。
     *
     * @return フィールド[transsourcelang]から取得した値。
     */
    public String getTranssourcelang() {
        return fTranssourcelang;
    }

    /**
     * フィールド [transtargetlang] の値を設定します。
     *
     * フィールドの説明: [翻訳先言語]。
     *
     * @param argTranstargetlang フィールド[transtargetlang]に設定する値。
     */
    public void setTranstargetlang(final String argTranstargetlang) {
        fTranstargetlang = argTranstargetlang;
    }

    /**
     * フィールド [transtargetlang] の値を取得します。
     *
     * フィールドの説明: [翻訳先言語]。
     * デフォルト: [ja-JP]。
     *
     * @return フィールド[transtargetlang]から取得した値。
     */
    public String getTranstargetlang() {
        return fTranstargetlang;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.twa.filter.core.valueobject.BentenConvertToXliffProcessInput[");
        buf.append("verbose=" + fVerbose);
        buf.append(",sourcedir=" + fSourcedir);
        buf.append(",targetdir=" + fTargetdir);
        buf.append(",transtargetid=" + fTranstargetid);
        buf.append(",transsourcelang=" + fTranssourcelang);
        buf.append(",transtargetlang=" + fTranstargetlang);
        buf.append("]");
        return buf.toString();
    }
}
