/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.tm.ui.views.messages;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * TM ビューのためのメッセージ。
 *
 * リソースバンドル定義: [TranslationViewMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class TranslationViewMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * TranslationViewMessagesクラスのコンストラクタ。
     *
     * 基底名[TranslationViewMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public TranslationViewMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/tm/ui/views/messages/TranslationViewMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * TranslationViewMessagesクラスのコンストラクタ。
     *
     * 基底名[TranslationViewMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public TranslationViewMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/tm/ui/views/messages/TranslationViewMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * TranslationViewMessagesクラスのコンストラクタ。
     *
     * 基底名[TranslationViewMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public TranslationViewMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/tm/ui/views/messages/TranslationViewMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[TranslationViewMessages], key[Origin]
     *
     * [Origin] (en)<br>
     * [起源] (ja)<br>
     *
     * @return key[Origin]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getOrigin() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Origin";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Origin");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationViewMessages], key[Quality]
     *
     * [Quality] (en)<br>
     * [品質] (ja)<br>
     *
     * @return key[Quality]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getQuality() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Quality";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Quality");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationViewMessages], key[Source]
     *
     * [Source] (en)<br>
     * [ソース] (ja)<br>
     *
     * @return key[Source]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getSource() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Source";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Source");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationViewMessages], key[Target]
     *
     * [Target] (en)<br>
     * [ターゲット] (ja)<br>
     *
     * @return key[Target]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getTarget() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Target";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Target");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationViewMessages], key[CopySource]
     *
     * [Copy Source] (en)<br>
     * [ソースのコピー] (ja)<br>
     *
     * @return key[CopySource]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCopySource() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Copy Source";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CopySource");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[TranslationViewMessages], key[CopyTarget]
     *
     * [Copy Target] (en)<br>
     * [ターゲットのコピー] (ja)<br>
     *
     * @return key[CopyTarget]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getCopyTarget() {
        // 初期値として定義書の値を利用します。
        String strFormat = "Copy Target";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CopyTarget");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
