/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.tm.ui.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * CAT TM UI プラグインのためのメッセージ。
 *
 * リソースバンドル定義: [CatTmUiPluginMessages]。<BR>
 * このクラスはリソースバンドル定義書から自動生成されたリソースバンドルクラスです。<BR>
 * 既知のロケール<BR>
 * <UL>
 * <LI>en
 * <LI>ja
 * </UL>
 */
public class CatTmUiPluginMessages {
    /**
     * リソースバンドルオブジェクト。
     *
     * 内部的に実際に入力を行うリソースバンドルを記憶します。
     */
    private ResourceBundle fResourceBundle;

    /**
     * CatTmUiPluginMessagesクラスのコンストラクタ。
     *
     * 基底名[CatTmUiPluginMessages]、デフォルトのロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     */
    public CatTmUiPluginMessages() {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/tm/ui/messages/CatTmUiPluginMessages");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * CatTmUiPluginMessagesクラスのコンストラクタ。
     *
     * 基底名[CatTmUiPluginMessages]、指定されたロケール、呼び出し側のクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     */
    public CatTmUiPluginMessages(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/tm/ui/messages/CatTmUiPluginMessages", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * CatTmUiPluginMessagesクラスのコンストラクタ。
     *
     * 基底名[CatTmUiPluginMessages]、指定されたロケール、指定されたクラスローダを使用して、リソースバンドルを取得します。
     *
     * @param locale ロケールの指定
     * @param loader クラスローダの指定
     */
    public CatTmUiPluginMessages(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("benten/cat/tm/ui/messages/CatTmUiPluginMessages", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * 内部的に保持しているリソースバンドルオブジェクトを取得します。
     *
     * @return 内部的に保持しているリソースバンドルオブジェクト。
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[CatTmUiPluginMessages], key[Msg.001]
     *
     * [{0}\nFailed to load the TM data.\nConfirm the setting by selecting Translation &gt; TM Preference &gt; TMX Location.] (en)<br>
     * [{0}\nTM データのロードに失敗しました\n翻訳 &gt; TM 設定 &gt; 使用する TMX ロケーション を確認してください。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[Msg.001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg001(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "{0}\nFailed to load the TM data.\nConfirm the setting by selecting Translation > TM Preference > TMX Location.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.001");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[CatTmUiPluginMessages], key[Msg.002]
     *
     * [{0}\nFailed to load the specified TM engine\nConfirm the setting by selecting Translation &gt; TM Preference &gt; TM Engine.\nPlease modify the preferences of TM engine or confirm that the necessary plug-ins are properly installed.] (en)<br>
     * [{0}\n指定された TM エンジンのロードに失敗しました\n翻訳 &gt; TM 設定 &gt; TM エンジン を確認してください。\n利用する TM エンジンの設定を変更するか、あるいは必要なプラグインが適切に導入されていることを確認してください。] (ja)<br>
     *
     * @param arg0 置換文字列{0}を置換する値。java.lang.String型を与えてください。
     * @return key[Msg.002]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getMsg002(final String arg0) {
        // 初期値として定義書の値を利用します。
        String strFormat = "{0}\nFailed to load the specified TM engine\nConfirm the setting by selecting Translation > TM Preference > TM Engine.\nPlease modify the preferences of TM engine or confirm that the necessary plug-ins are properly installed.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("Msg.002");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // 与えられた引数を元に置換文字列を置き換えます。
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[CatTmUiPluginMessages], key[getTmEnginePlugin_E001]
     *
     * [It was unable to get the extension point (benten.cat.tm.engine).] (en)<br>
     * [拡張ポイント(benten.cat.tm.engine) を取得することができませんでした。] (ja)<br>
     *
     * @return key[getTmEnginePlugin_E001]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getGetTmEnginePluginE001() {
        // 初期値として定義書の値を利用します。
        String strFormat = "It was unable to get the extension point (benten.cat.tm.engine).";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("getTmEnginePlugin_E001");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }

    /**
     * bundle[CatTmUiPluginMessages], key[getTmEnginePlugin_E002]
     *
     * [It was unable to get the TM engine plug-in from the extension point.] (en)<br>
     * [拡張ポイントから TM エンジン・プラグインを取得することができませんでした。] (ja)<br>
     *
     * @return key[getTmEnginePlugin_E002]に対応する値。外部から読み込みができない場合には、定義書の値を戻します。必ずnull以外の値が戻ります。
     */
    public String getGetTmEnginePluginE002() {
        // 初期値として定義書の値を利用します。
        String strFormat = "It was unable to get the TM engine plug-in from the extension point.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("getTmEnginePlugin_E002");
            }
        } catch (MissingResourceException ex) {
        }
        // 置換文字列はひとつもありません。
        return strFormat;
    }
}
