/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.ui.views;

import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.dialogs.PreferencesUtil;

import benten.ui.UiPlugin;

/**
 * 設定へリンクするための部品。
 *
 * @deprecated ボタンによる実装に置き換えられました。このクラスは削除予定です。
 * @author KASHIHARA Shinji
 */
@Deprecated
public class PreferenceLink {

	/**
	 * コンストラクター。
	 * @param parent 親コンポジット
	 * @param text テキスト
	 * @param preferenceId 設定 id
	 */
	public PreferenceLink(final Composite parent, final String text, final String preferenceId) {
		final Link link = new Link(parent, SWT.NONE);
		link.setText(text);
		link.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(final SelectionEvent e) {
				showPreferencePage(preferenceId);
			}
		});
	}

	/**
	 * 設定ページの表示。
	 * @param pageId 拡張ポイントとして定義されたページ id
	 * @return OK ボタンが押された場合は true
	 */
	public static boolean showPreferencePage(final String pageId) {
		final PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(UiPlugin.getShell(), pageId,
				new String[] { pageId }, null);
		return dialog.open() == Window.OK;
	}
}
