/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.xliff.core.valueobject;

/**
 * 処理クラス [BentenExtractXliffFragmentProcess]の入力バリューオブジェクトクラスです。
 */
public class BentenExtractXliffFragmentProcessInput {
    /**
     * verboseモードで動作させるかどうか。
     *
     * フィールド: [verbose]。
     * デフォルト: [false]。
     */
    private boolean fVerbose = false;

    /**
     * 抽出元となる XLIFF ファイル。
     *
     * フィールド: [sourcexlifffile]。
     */
    private String fSourcexlifffile;

    /**
     * 抽出先となる XLIFF を格納するディレクトリ。
     *
     * フィールド: [targetxliffdir]。
     */
    private String fTargetxliffdir;

    /**
     * 状態で抽出する場合の state 値。無指定なら state で抽出しない。target無しで絞り込みたい場合には、半角空白 1 つをセット。
     *
     * フィールド: [extractbystate]。
     */
    private String fExtractbystate;

    /**
     * 件数で区切って抽出する場合の件数値。無指定なら -1 で件数では区切らない。
     *
     * フィールド: [limitsize]。
     * デフォルト: [-1]。
     */
    private int fLimitsize = -1;

    /**
     * ファイル名に日付を含めるかどうか。
     *
     * フィールド: [includedate]。
     * デフォルト: [false]。
     */
    private boolean fIncludedate = false;

    /**
     * フィールド [verbose] の値を設定します。
     *
     * フィールドの説明: [verboseモードで動作させるかどうか。]。
     *
     * @param argVerbose フィールド[verbose]に設定する値。
     */
    public void setVerbose(final boolean argVerbose) {
        fVerbose = argVerbose;
    }

    /**
     * フィールド [verbose] の値を取得します。
     *
     * フィールドの説明: [verboseモードで動作させるかどうか。]。
     * デフォルト: [false]。
     *
     * @return フィールド[verbose]から取得した値。
     */
    public boolean getVerbose() {
        return fVerbose;
    }

    /**
     * フィールド [sourcexlifffile] の値を設定します。
     *
     * フィールドの説明: [抽出元となる XLIFF ファイル。]。
     *
     * @param argSourcexlifffile フィールド[sourcexlifffile]に設定する値。
     */
    public void setSourcexlifffile(final String argSourcexlifffile) {
        fSourcexlifffile = argSourcexlifffile;
    }

    /**
     * フィールド [sourcexlifffile] の値を取得します。
     *
     * フィールドの説明: [抽出元となる XLIFF ファイル。]。
     *
     * @return フィールド[sourcexlifffile]から取得した値。
     */
    public String getSourcexlifffile() {
        return fSourcexlifffile;
    }

    /**
     * フィールド [targetxliffdir] の値を設定します。
     *
     * フィールドの説明: [抽出先となる XLIFF を格納するディレクトリ。]。
     *
     * @param argTargetxliffdir フィールド[targetxliffdir]に設定する値。
     */
    public void setTargetxliffdir(final String argTargetxliffdir) {
        fTargetxliffdir = argTargetxliffdir;
    }

    /**
     * フィールド [targetxliffdir] の値を取得します。
     *
     * フィールドの説明: [抽出先となる XLIFF を格納するディレクトリ。]。
     *
     * @return フィールド[targetxliffdir]から取得した値。
     */
    public String getTargetxliffdir() {
        return fTargetxliffdir;
    }

    /**
     * フィールド [extractbystate] の値を設定します。
     *
     * フィールドの説明: [状態で抽出する場合の state 値。無指定なら state で抽出しない。target無しで絞り込みたい場合には、半角空白 1 つをセット。]。
     *
     * @param argExtractbystate フィールド[extractbystate]に設定する値。
     */
    public void setExtractbystate(final String argExtractbystate) {
        fExtractbystate = argExtractbystate;
    }

    /**
     * フィールド [extractbystate] の値を取得します。
     *
     * フィールドの説明: [状態で抽出する場合の state 値。無指定なら state で抽出しない。target無しで絞り込みたい場合には、半角空白 1 つをセット。]。
     *
     * @return フィールド[extractbystate]から取得した値。
     */
    public String getExtractbystate() {
        return fExtractbystate;
    }

    /**
     * フィールド [limitsize] の値を設定します。
     *
     * フィールドの説明: [件数で区切って抽出する場合の件数値。無指定なら -1 で件数では区切らない。]。
     *
     * @param argLimitsize フィールド[limitsize]に設定する値。
     */
    public void setLimitsize(final int argLimitsize) {
        fLimitsize = argLimitsize;
    }

    /**
     * フィールド [limitsize] の値を取得します。
     *
     * フィールドの説明: [件数で区切って抽出する場合の件数値。無指定なら -1 で件数では区切らない。]。
     * デフォルト: [-1]。
     *
     * @return フィールド[limitsize]から取得した値。
     */
    public int getLimitsize() {
        return fLimitsize;
    }

    /**
     * フィールド [includedate] の値を設定します。
     *
     * フィールドの説明: [ファイル名に日付を含めるかどうか。]。
     *
     * @param argIncludedate フィールド[includedate]に設定する値。
     */
    public void setIncludedate(final boolean argIncludedate) {
        fIncludedate = argIncludedate;
    }

    /**
     * フィールド [includedate] の値を取得します。
     *
     * フィールドの説明: [ファイル名に日付を含めるかどうか。]。
     * デフォルト: [false]。
     *
     * @return フィールド[includedate]から取得した値。
     */
    public boolean getIncludedate() {
        return fIncludedate;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.twa.xliff.core.valueobject.BentenExtractXliffFragmentProcessInput[");
        buf.append("verbose=" + fVerbose);
        buf.append(",sourcexlifffile=" + fSourcexlifffile);
        buf.append(",targetxliffdir=" + fTargetxliffdir);
        buf.append(",extractbystate=" + fExtractbystate);
        buf.append(",limitsize=" + fLimitsize);
        buf.append(",includedate=" + fIncludedate);
        buf.append("]");
        return buf.toString();
    }
}
