/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.core.io;

import java.io.File;
import java.io.FilenameFilter;

import benten.core.BentenConstants;

/**
 * 拡張子による XLIFF ファイル・フィルター。
 * 
 * @author KASHIHARA Shinji
 */
public class XliffFileFilter implements FilenameFilter {

	/** このクラスのシングルトン・インスタンス */
	public static final FilenameFilter INSTANCE = new XliffFileFilter();

	/**
	 * 隠されたコンストラクター。
	 * 
	 * <UL>
	 * <LI>このクラスはユーティリティ・クラスです。
	 * <LI>インスタンス生成を抑制するために、コンストラクターは private で修飾されています。
	 * </UL>
	 */
	private XliffFileFilter() {
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean accept(final File dir, final String name) {
		return name.endsWith(BentenConstants.FILE_EXT_XLIFF);
	}

	/**
	 * ファイルに拡張子を追加。
	 * @param file ファイル
	 * @return 追加後のファイル
	 */
	public static File appendExtension(final File file) {
		return new File(file + BentenConstants.FILE_EXT_XLIFF);
	}
}
