/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.cat.stat.model;

import java.io.File;

/**
 * 統計情報のための抽象モデル・クラス。
 */
public abstract class AbstractStatModel {
    /**
     * フィールド: [file]。
     */
    private File fFile;

    /**
     * フィールド [file] の値を設定します。
     *
     * @param argFile フィールド[file]に設定する値。
     */
    public void setFile(final File argFile) {
        fFile = argFile;
    }

    /**
     * フィールド [file] の値を取得します。
     *
     * @return フィールド[file]から取得した値。
     */
    public File getFile() {
        return fFile;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.cat.stat.model.AbstractStatModel[");
        buf.append("file=" + fFile);
        buf.append("]");
        return buf.toString();
    }
}
