/*******************************************************************************
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *******************************************************************************/
package benten.twa.cat.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;

import benten.twa.cat.dialogs.MarkNoTransableDialog;
import benten.twa.cat.messages.BentenMarkNoTransableMessages;
import benten.twa.ui.dialogs.AbstractWorkflowDialog;
import benten.twa.ui.wizards.AbstractWorkflowDialogWizardPage;

/**
 * 翻訳対象外のマーク
 *
 * <pre>
 * XLIFF 内の翻訳の必要のない翻訳単位を、翻訳対象外としてマークします。
 *   1.  XLIFF の翻訳単位の内容から、翻訳の必要の有無を判断します。
 *   2.  翻訳の必要がないと判断されたものについて、翻訳対象外としてマークします。
 * </pre>
 *
 * ★基本設計「翻訳ワークフロー支援機能: 翻訳中間形式機械支援翻訳機能: 非翻訳対象マーク機能」に対応します。
 *
 * @author YAMAMOTO Koji
 */
public class MarkNoTransableWizardPage2 extends AbstractWorkflowDialogWizardPage {
	/**
	 * 翻訳対象外マーク機能のためのメッセージ。
	 */
	protected static final BentenMarkNoTransableMessages fMsg = new BentenMarkNoTransableMessages();

	/**
	 * コンストラクター。
	 * @param selection 選択
	 */
	protected MarkNoTransableWizardPage2(final IStructuredSelection selection) {
		super(selection);
		setTitle(fMsg.getWizardPage2Title());
		setDescription(fMsg.getWizardPage2Description());
	}

	@Override
	public AbstractWorkflowDialog createWorkflowDialog(final Composite parent, final IStructuredSelection selection) {
		return new MarkNoTransableDialog(parent.getShell(), selection);
	}
}
