/*
 * Copyright (c) 2009 Information-technology Promotion Agency, Japan.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package benten.twa.filter.core.valueobject;

/**
 * 処理クラス [BentenImportHtmlProcess]の入力バリューオブジェクトクラスです。
 */
public class BentenImportHtmlProcessInput {
    /**
     * verboseモードで動作させるかどうか。
     *
     * フィールド: [verbose]。
     * デフォルト: [false]。
     */
    private boolean fVerbose = false;

    /**
     * インポート元となる HTML が格納されたディレクトリ。
     *
     * フィールド: [sourcedir]。
     */
    private String fSourcedir;

    /**
     * インポート先となる HTML を格納するディレクトリ。
     *
     * フィールド: [targetdir]。
     */
    private String fTargetdir;

    /**
     * インポートの際に html を正常化するかどうか。
     *
     * フィールド: [normalizehtml]。
     * デフォルト: [true]。
     */
    private boolean fNormalizehtml = true;

    /**
     * フィールド [verbose] の値を設定します。
     *
     * フィールドの説明: [verboseモードで動作させるかどうか。]。
     *
     * @param argVerbose フィールド[verbose]に設定する値。
     */
    public void setVerbose(final boolean argVerbose) {
        fVerbose = argVerbose;
    }

    /**
     * フィールド [verbose] の値を取得します。
     *
     * フィールドの説明: [verboseモードで動作させるかどうか。]。
     * デフォルト: [false]。
     *
     * @return フィールド[verbose]から取得した値。
     */
    public boolean getVerbose() {
        return fVerbose;
    }

    /**
     * フィールド [sourcedir] の値を設定します。
     *
     * フィールドの説明: [インポート元となる HTML が格納されたディレクトリ。]。
     *
     * @param argSourcedir フィールド[sourcedir]に設定する値。
     */
    public void setSourcedir(final String argSourcedir) {
        fSourcedir = argSourcedir;
    }

    /**
     * フィールド [sourcedir] の値を取得します。
     *
     * フィールドの説明: [インポート元となる HTML が格納されたディレクトリ。]。
     *
     * @return フィールド[sourcedir]から取得した値。
     */
    public String getSourcedir() {
        return fSourcedir;
    }

    /**
     * フィールド [targetdir] の値を設定します。
     *
     * フィールドの説明: [インポート先となる HTML を格納するディレクトリ。]。
     *
     * @param argTargetdir フィールド[targetdir]に設定する値。
     */
    public void setTargetdir(final String argTargetdir) {
        fTargetdir = argTargetdir;
    }

    /**
     * フィールド [targetdir] の値を取得します。
     *
     * フィールドの説明: [インポート先となる HTML を格納するディレクトリ。]。
     *
     * @return フィールド[targetdir]から取得した値。
     */
    public String getTargetdir() {
        return fTargetdir;
    }

    /**
     * フィールド [normalizehtml] の値を設定します。
     *
     * フィールドの説明: [インポートの際に html を正常化するかどうか。]。
     *
     * @param argNormalizehtml フィールド[normalizehtml]に設定する値。
     */
    public void setNormalizehtml(final boolean argNormalizehtml) {
        fNormalizehtml = argNormalizehtml;
    }

    /**
     * フィールド [normalizehtml] の値を取得します。
     *
     * フィールドの説明: [インポートの際に html を正常化するかどうか。]。
     * デフォルト: [true]。
     *
     * @return フィールド[normalizehtml]から取得した値。
     */
    public boolean getNormalizehtml() {
        return fNormalizehtml;
    }

    /**
     * このバリューオブジェクトの文字列表現を取得します。
     *
     * <P>使用上の注意</P>
     * <UL>
     * <LI>オブジェクトのシャロー範囲のみ文字列化の処理対象となります。
     * <LI>オブジェクトが循環参照している場合には、このメソッドは使わないでください。
     * </UL>
     *
     * @return バリューオブジェクトの文字列表現。
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("benten.twa.filter.core.valueobject.BentenImportHtmlProcessInput[");
        buf.append("verbose=" + fVerbose);
        buf.append(",sourcedir=" + fSourcedir);
        buf.append(",targetdir=" + fTargetdir);
        buf.append(",normalizehtml=" + fNormalizehtml);
        buf.append("]");
        return buf.toString();
    }
}
