/*!
  \example
  \brief ConvertToGrid ̓Tv

  \author Satofumi KAMIMURA

  $Id$
*/

#include "UrgCtrl.h"
#include "ConvertToGrid.h"
#include <SDL.h>

using namespace beego;


int main(int argc, char *argv[]) {

  UrgCtrl urg;
  if (! urg.connect(argc, argv)) {
    printf("UrgCtrl::connect: %s\n", urg.what());
    exit(1);
  }

  size_t data_max = urg.getMaxDataLength();
  long* data = new long[data_max];

  int n = urg.capture(data, data_max);
  if (n <= 0) {
    fprintf(stderr, "n = %d\n", n);
  } else {
    std::vector<Grid<int> > points;
    convertToGrid(points, data, data_max, &urg);
    for (std::vector<Grid<int> >::iterator it = points.begin();
	 it != points.end(); ++it) {
      printf("%d\t%d\n", it->x, it->y);
    }
  }

  delete [] data;
  return 0;
}
