/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.kino.plugin.beangenerator.handlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import nu.mine.kino.plugin.beangenerator.Activator;
import nu.mine.kino.plugin.beangenerator.Messages;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class TemplateCreateHandler
extends AbstractHandler
implements IHandler {
    private static final Logger logger = Logger.getLogger(TemplateCreateHandler.class);
    private static final String XLS1 = "JavaBeansSample.xls";
    private static final String XLS2 = "JavaBeansSampleAnno.xls";
    private static final String[] XLSs = new String[]{"JavaBeansSample.xls", "JavaBeansSampleAnno.xls"};

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (!MessageDialog.openConfirm((Shell)shell, (String)Messages.TemplateCreateAction_MESSAGE_DIALOG, (String)(String.valueOf(Messages.TemplateCreateAction_MESSAGE_CONFIRM) + XLS1 + ",  " + XLS2))) {
            return null;
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        dialog.setCancelable(true);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IStructuredSelection ss = null;
        if (selection instanceof IStructuredSelection) {
            ss = (IStructuredSelection)selection;
        }
        try {
            Object progress = null;
            Object firstElementObj = ss.getFirstElement();
            if (firstElementObj instanceof IResource) {
                final IResource firstElement = (IResource)ss.getFirstElement();
                progress = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IProject project = firstElement.getProject();
                        TemplateCreateHandler.this.createFile(project, TemplateCreateHandler.XLS1, monitor);
                        TemplateCreateHandler.this.createFile(project, TemplateCreateHandler.XLS2, monitor);
                    }
                };
            } else if (firstElementObj instanceof IJavaProject) {
                final IJavaProject firstElement = (IJavaProject)ss.getFirstElement();
                progress = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IProject project = firstElement.getProject();
                        TemplateCreateHandler.this.createFiles(project, monitor, XLSs);
                    }
                };
            }
            dialog.run(true, true, progress);
        }
        catch (InvocationTargetException e) {
            Activator.logException(e);
        }
        catch (InterruptedException e) {
            Activator.logException(e, false);
        }
        return null;
    }

    private void createFiles(IProject project, IProgressMonitor monitor, String ... fileNames) throws InvocationTargetException {
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            this.createFile(project, filename, monitor);
            ++n2;
        }
    }

    private void createFile(IProject project, String fileName, IProgressMonitor monitor) throws InvocationTargetException {
        IFile destFile = project.getFile((IPath)new Path(fileName));
        try {
            if (destFile.exists()) {
                destFile.delete(false, null);
            }
            URL entry = Activator.getDefault().getBundle().getEntry("/");
            String pluginDirectory = FileLocator.resolve((URL)entry).getPath();
            File sourceFile = new File(pluginDirectory, fileName);
            destFile.create((InputStream)new FileInputStream(sourceFile), true, monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        catch (FileNotFoundException e) {
            throw new InvocationTargetException(e);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }
}

