/*
 * Decompiled with CFR 0.152.
 */
package nu.mine.kino.plugin.beangenerator;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import nu.mine.kino.plugin.beangenerator.Activator;
import nu.mine.kino.plugin.beangenerator.Messages;
import nu.mine.kino.plugin.beangenerator.sheetdata.IClassInformation;
import nu.mine.kino.plugin.beangenerator.sheetdata.IFieldInformation;
import org.apache.commons.lang.WordUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;

public class JavaBeansCreator {
    private static final Logger logger = Logger.getLogger(JavaBeansCreator.class);
    private final IJavaProject javaProject;

    public JavaBeansCreator(IJavaProject javaProject) {
        this.javaProject = javaProject;
        URL entry = Activator.getDefault().getBundle().getEntry("/");
        try {
            String pluginDirectory = FileLocator.resolve((URL)entry).getPath();
            File file = new File(pluginDirectory, "lib");
            Properties p = new Properties();
            p.setProperty("file.resource.loader.path", file.getAbsolutePath());
            Velocity.init((Properties)p);
        }
        catch (IOException e) {
            logger.error((Object)"JavaBeansCreator()", (Throwable)e);
            Activator.logException(e);
        }
        catch (Exception e) {
            logger.error((Object)"JavaBeansCreator()", (Throwable)e);
            Activator.logException(e);
        }
    }

    public ICompilationUnit create(IClassInformation info) throws CoreException {
        logger.debug((Object)"create(ClassInformation) - start");
        IPackageFragmentRoot root = this.getSourceDir(this.javaProject);
        String pkg = info.getPackageName();
        IPackageFragment pack = root.getPackageFragment(pkg);
        if (!pack.exists()) {
            pack = root.createPackageFragment(pkg, true, (IProgressMonitor)new NullProgressMonitor());
        }
        String mainStatement = this.createMain(info);
        ICompilationUnit cu = pack.createCompilationUnit(String.valueOf(info.getClassName()) + ".java", mainStatement, true, (IProgressMonitor)new NullProgressMonitor());
        IType type = cu.getType(info.getClassName());
        this.createField(type, info);
        this.createSetter(type, info);
        this.createGetter(type, info);
        if (this.contains(info.getToString(), "\u25cb")) {
            this.createToString(type, info);
        }
        cu.save((IProgressMonitor)new NullProgressMonitor(), true);
        logger.debug((Object)"create(ClassInformation) - end");
        return cu;
    }

    private String executeVelocity(String vm, String[] names, Object[] objs) throws CoreException {
        logger.debug((Object)"executeVelocity(String, String[], Object[]) - start");
        try {
            VelocityContext context = new VelocityContext();
            int i = 0;
            while (i < names.length) {
                context.put(names[i], objs[i]);
                ++i;
            }
            StringWriter out = new StringWriter();
            Template template = Velocity.getTemplate((String)vm, (String)"MS932");
            template.merge((Context)context, (Writer)out);
            String result = out.toString();
            out.flush();
            logger.debug((Object)"executeVelocity(String, String[], Object[]) - end");
            return result;
        }
        catch (Exception e) {
            logger.error((Object)"executeVelocity(String, String[], Object[])", (Throwable)e);
            Status status = new Status(4, Activator.getPluginId(), 0, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private String createMain(IClassInformation clazz) throws CoreException {
        return this.executeVelocity("main.vm", new String[]{"class"}, new IClassInformation[]{clazz});
    }

    private void createField(IType type, IClassInformation info) throws CoreException {
        logger.debug((Object)"createField() start");
        StringBuffer buf = new StringBuffer();
        List<IFieldInformation> fieldInformations = info.getFieldInformations();
        for (IFieldInformation field : fieldInformations) {
            String result = this.executeVelocity("field.vm", new String[]{"field"}, new IFieldInformation[]{field});
            buf.append(result);
        }
        type.createField(buf.toString(), null, true, (IProgressMonitor)new NullProgressMonitor());
        logger.debug((Object)"createField() end");
    }

    private void createToString(IType type, IClassInformation info) throws CoreException {
        StringBuffer buf = new StringBuffer();
        List<IFieldInformation> fieldInformations = info.getFieldInformations();
        for (IFieldInformation field : fieldInformations) {
            String key = field.getFieldNameJ();
            String value = field.getFieldName();
            buf.append(".append(\"");
            buf.append(key);
            buf.append("\",");
            buf.append(value);
            buf.append(")");
        }
        buf.append(".toString();");
        String toString = this.executeVelocity("toString.vm", new String[]{"toString"}, new String[]{new String(buf)});
        type.createMethod(toString, null, true, (IProgressMonitor)new NullProgressMonitor());
    }

    private void createGetter(IType type, IClassInformation info) throws CoreException {
        logger.debug((Object)"createGetter() start");
        List<IFieldInformation> fieldInformations = info.getFieldInformations();
        for (IFieldInformation field : fieldInformations) {
            String prefix = null;
            prefix = this.contains(field.getFieldType(), "boolean", "java.lang.Boolean") ? "is" : "get";
            String[] keys = new String[]{"field", "cname", "prefix"};
            Object[] values = new Object[]{field, WordUtils.capitalize((String)field.getFieldName()), prefix};
            String getter = this.executeVelocity("getter.vm", keys, values);
            type.createMethod(getter, null, true, (IProgressMonitor)new NullProgressMonitor());
        }
        logger.debug((Object)"createGetter() end");
    }

    private void createSetter(IType type, IClassInformation info) throws CoreException {
        logger.debug((Object)"createSetter() start");
        List<IFieldInformation> fieldInformations = info.getFieldInformations();
        for (IFieldInformation field : fieldInformations) {
            String[] keys = new String[]{"field", "cname"};
            Object[] values = new Object[]{field, WordUtils.capitalize((String)field.getFieldName())};
            String setter = this.executeVelocity("setter.vm", keys, values);
            type.createMethod(setter, null, true, (IProgressMonitor)new NullProgressMonitor());
        }
        logger.debug((Object)"createSetter() end");
    }

    private boolean contains(String input, String ... strs) {
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (input.equals(str)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private IPackageFragmentRoot getSourceDir(IJavaProject javaProject) throws CoreException {
        IPackageFragmentRoot[] roots;
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.getKind() == 1) {
                return root;
            }
            ++n2;
        }
        Status status = new Status(4, Activator.getPluginId(), 0, Messages.JavaBeansCreator_MSG_SRCDIR_NOT_FOUND, null);
        throw new CoreException((IStatus)status);
    }
}

