using System;
using System.Reflection;
using AttoContainer.Aop.Interceptor;

namespace AttoContainer.Aop
{
	/// <summary>
	/// MethodInvocation
	/// </summary>
	public class MethodInvocation : IMethodInvocation
	{
		private Object target;
		private MethodInfo methodInfo;
		private IMethodInterceptor[] interceptors;
		private int interceptorsIndex = 1;
		private Object[] arguments;
		
		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="target">InterceptIuWFNg</param>
		/// <param name="methodInfo">Intercept郁\bhMethodInfo</param>
		/// <param name="interceptors">\bhInterceptInterceptor</param>
		public MethodInvocation(object target,MethodInfo methodInfo,object[] arguments,IMethodInterceptor[] interceptors)
		{
			if(target==null) throw new NullReferenceException("target");
			if(methodInfo==null) throw new NullReferenceException("methodInfo");
			if(interceptors==null) throw new NullReferenceException("interceptors");
			this.target = target;
			this.methodInfo = methodInfo;
			this.arguments = arguments;
			this.interceptors = interceptors;
			
		}

		#region IMethodInvocation o

		/// <summary>
		/// Intercept郁\bhMethodInfo
		/// </summary>
		public MethodInfo MethodInfo
		{
			get
			{
				return methodInfo;
			}
		}

		/// <summary>
		/// InterceptIuWFNg
		/// </summary>
		public Object Target
		{
			get
			{
				return target;
			}
		}

		/// <summary>
		/// Intercept郁\bḧ
		/// </summary>
		public Object[] Arguments
		{
			get
			{
				return arguments;
			}
		}

		/// <summary>
		/// Ƀ`F[ĂInterceptor΁AInterceptorĂяo܂iċAIɌĂяoj
		/// Ƀ`F[ĂInterceptor΁AInterceptĂ郁\bhs܂
		/// </summary>
		/// <returns>Interceptꂽ\bh̖߂l</returns>
		public Object Proceed()
		{
			while(interceptorsIndex < interceptors.Length)
			{
				// Interceptor΁AInterceptorĂяo
				return interceptors[interceptorsIndex++].Invoke(this);
			}
			// Interceptꂽ\bhs
			return methodInfo.Invoke(target,arguments);
		}

		#endregion
	}
}
