using System;
using System.Data;
using System.IO;
using System.Reflection;
using System.Collections;
using TestAttoContainerLib.Logic;

namespace AttoContainer
{
	/// <summary>
	/// DIContainer
	/// </summary>
	public class DIContainer : IDisposable
	{

		protected DataSet componentDataSet;
		protected DataTable components;
		protected IList assemblys;
		protected Hashtable instances = new Hashtable();

		/// <summary>
		/// VOgp^[̂߁AJ̃RXgN^
		/// </summary>
		private DIContainer()
		{
		}

		/// <summary>
		/// DIContainer̃CX^X𐶐܂
		/// </summary>
		/// <param name="configPath">ݒt@C̃pX</param>
		/// <param name="encoding">ݒt@C̃GR[h</param>
		/// <returns>DIContainer̃CX^X</returns>
		public static DIContainer Instance(string configPath,System.Text.Encoding encoding)
		{
			StreamReader reader = new StreamReader(configPath,encoding);

			DataSet dtSet = new DataSet();

			// f[^ZbgXMLt@Cǂݍ
			dtSet.ReadXml(reader);

			DIContainer diContainer = new DIContainer();
			diContainer.ComponentDataSet = dtSet;
			
			// AZũZbg
			IList asms = new ArrayList();
			DataTable assemblyTable = dtSet.Tables["assembly"];
			foreach(DataRow row in assemblyTable.Rows)
			{
				string asmName = (string)row["name"];
				asms.Add(Assembly.LoadFrom(asmName));
			}
			diContainer.Assemblys = asms;

			return diContainer;
		}

		/// <summary>
		/// typeCX^X쐬AɑvpeBɃR|[lgZbg܂
		/// </summary>
		/// <param name="type">CX^X𐶐NXType</param>
		/// <returns>DIContainerɂ쐬ꂽObject</returns>
		public Object GetComponent(Type type)
		{
			components = componentDataSet.Tables["component"];
			
			// typeCX^X쐬
			Object component = type.InvokeMember(null, BindingFlags.CreateInstance,null,null,null);

			// componentɑvpeBɃR|[lg쐬Zbg
			setComponent(component);
			
			return component;
		}

		/// <summary>
		/// componentɑvpeBɃR|[lg쐬Zbg܂
		/// </summary>
		/// <param name="component">R|[lg</param>
		protected void setComponent(Object component)
		{

			//o擾
			MemberInfo[] members = component.GetType().GetMembers(
				BindingFlags.Public | BindingFlags.Instance );

			foreach (MemberInfo m in members)
			{
				// ovpeB̏ꍇ
				if(MemberTypes.Property != m.MemberType) continue;
				
				// LbVCX^X擾
				Object obj = instances[m.Name];
				if(obj == null) 
				{
					// DataRowCollectionCX^X쐬
					obj = createInstanceFromDataRowCollection(m);
					if(obj==null) continue;
				}
				// component̃vpeBɃR|[lgZbg
				component.GetType().InvokeMember(m.Name,BindingFlags.SetProperty
					,null,component,new object[] {obj});
			}	
		}

		/// <summary>
		/// DataRowCollectionCX^X쐬Ԃ܂
		/// </summary>
		/// <param name="m">MemberInfo</param>
		/// <returns>ꂽObject</returns>
		protected Object createInstanceFromDataRowCollection(MemberInfo m)
		{
			Object obj = null;

			foreach(DataRow row in components.Rows)
			{
				// TĂR|[lgł͂Ȃꍇ͎component
				if(!m.Name.Equals((string)row["name"])) continue;
						
				// AZuclassNamẽNXTCX^X쐬
				obj = createInstance((string)row["class"]);

				// CX^X쐬łȂꍇ͎̃vpeB
				if(obj == null) break;

				// LbVɊi[
				instances.Add(m.Name,obj);

				// 쐬CX^XɃR|[lgZbg
				setComponent(obj);
				break;
			}
			return obj;
		}

		/// <summary>
		/// AZuclassNamẽNXTCX^X쐬Ԃ܂
		/// </summary>
		/// <param name="className">NX</param>
		/// <returns>ꂽCX^X</returns>
		protected Object createInstance(string className)
		{
			// AZuclassNameType擾
			Type t = searchTypeFromAssemblys(className);

			if(t == null) 
			{
				Console.WriteLine("AttoContainer: [" + className + "] ܂B");
				return null;
			}

			// TypeCX^X쐬ĕԂ
			return t.InvokeMember(null, BindingFlags.CreateInstance,null,null,null);
			
		}

		/// <summary>
		/// AZuclassNameType擾܂
		/// </summary>
		/// <param name="className">NX</param>
		/// <returns>NX琶ꂽType</returns>
		protected Type searchTypeFromAssemblys(string className)
		{
			Type t = null;
			foreach(Assembly asm in assemblys)
			{
				t = asm.GetType(className);
				if(t != null) break;
			}
			return t;
		}

		/// <summary>
		/// ݒt@C̃f[^Zbg
		/// </summary>
		public DataSet ComponentDataSet
		{
			set 
			{
				componentDataSet = value;
			}
			get
			{
				return componentDataSet;
			}
		}

		/// <summary>
		/// AZu
		/// </summary>
		public IList Assemblys
		{
			set
			{
				assemblys = value;
			}
			get
			{
				return assemblys;
			}
		}

		#region IDisposable o

		/// <summary>
		/// IuWFNgJ܂
		/// </summary>
		public void Dispose()
		{
			componentDataSet.Dispose();
			componentDataSet = null;
			components.Dispose();
			components = null;
			instances.Clear();
			instances = null;
			assemblys.Clear();
			assemblys = null;
		}

		#endregion
	}
}
