/*
ATFintek - Automatic VGA fan controler program with Fintek F57373S and F57355S/SP
v0.1 2009-10-01 (since 2009-09-24)

NO WARRANTY. USE THIS PROGRAM AT YOUR OWN RISK.

Copyright Masanori HATA <http://www.mihr.net/>. I distribute this code under the GPL Lisence.

Usage:
	> /usr/local/bin/atfintek 3 0x2d 60
Syntax:
	atfintek <device number> <slave address> <interval time>
Install:
	1. Copy 'atfintek' to '/usr/local/bin' and set permission appropriately.
	2. Add some lines to '/etc/rc.local'. For example:
		sleep 5
		/usr/local/bin/atfintek 3 0x2d 60 &
	('&' means 'run this command at background')
	3. reboot
Note:
	1a. You must install nvidia driver. 
	1b. You must enable both 'i2c_dev' and 'f75375s' modules in the '/etc/modules' before using this program.
	2. If you install nvidia driver and enable those modules correctly, you can know device number and slave address by using 'sensors-detect' command of lm-sensors tool.
	3. On OS boot, i2c_dev may take several seconds to set up '/dev/i2c-x' nodes. So, you may insert 5 or more seconds delay (ex. 'sleep 5') before starting this program at background (ex. '/usr/local/bin/atfintek 3 0x2d 60 &') in the start up shell script ('/etc/rc.local').
	4. This program works fine with my PC (Asus V9570 (GeForce FX 5700); Devian 5.03; ndivia driver 173.14.20).
	5. Although I am already good at Perl, this is my first C program.
*/

#include <linux/i2c-dev.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>

int FH;
__u8 temp_prev = 255;

read_word(__u8 reg1, __u8 reg2) {
	__u8 highbyte = i2c_smbus_read_byte_data(FH, reg1);
	__u8 lowbyte  = i2c_smbus_read_byte_data(FH, reg2);
	if (highbyte < 0 || lowbyte < 0) {
		printf("\nerror: i2c read transaction failed\n");
	} else {
		return highbyte * 256 + lowbyte;
	}
}

read_rpm() {
	int rpm = 1500000 / read_word(0x16, 0x17);
	printf("%d rpm\n", rpm);
}

change_pwmduty(__u8 duty) {
	__u8 byte = i2c_smbus_write_byte_data(FH, 0x76, duty);
	if (byte < 0) {
		printf("\nerror: i2c write transaction failed\n");
		exit(1);
	}	
}

check_temp() {
	__u8 temp = i2c_smbus_read_byte_data(FH, 0x14);
	if (temp <= 50) {
		if (temp_prev > 50) {
			change_pwmduty(0x0d);
		}
	} else if (temp <= 55) {
		if (temp_prev <= 50 || temp_prev > 55) {
			change_pwmduty(0x1a);
		}
	} else if (temp <= 60) {
		if (temp_prev <= 55 || temp_prev > 60) {
			change_pwmduty(0x27);
		}
	} else if (temp <= 65) {
		if (temp_prev <= 60 || temp_prev > 65) {
			change_pwmduty(0x34);
		}
	} else if (temp_prev <= 65) {
			change_pwmduty(0xff);
	}
	temp_prev = temp;
}

main(int argc, char *argv[]) {
	printf("Starting atfintek; ");

	if (argc != 4) {
		printf("error: you must specify three argument values.\n");
		printf("syntax: atfintek <device number> <slave address> <interval time>\n");
		exit(1);
	}
	
	char dev[13];
	int num = atoi(argv[1]);
	if (num < 0 || num > 255) {
		printf("error: device number must be [0-255].\n");
		exit(1);
	}
	else {
		sprintf(dev, "/dev/i2c-%d", num);
	}

	int interval = atoi(argv[3]);
	if (interval < 5 || interval > 60) {
		printf("error: polling interval time must be [5-60] seconds.\n");
		exit(1);
	}

	if ((FH = open(dev, O_RDWR)) < 0) {
		printf("error: i2c device opening failed; %s\n", strerror(errno));
		exit(1);
	} else {
		printf("adapter: %s; ", dev);
	}
	
	int addr = strtol(argv[2], NULL, 16);
	if (ioctl(FH, I2C_SLAVE, addr) < 0) {
		printf("\nerror: i2c slave access failed; %s\n", strerror(errno));
		exit(1);
	} else {
		printf("address: 0x%x; ", addr);
	}

	int id = read_word(0x5d, 0x5e);
	if (id == 6452) {
		printf("vendor: Fintek; ", id);
	} else {
		printf("\nerror: vendor id 0x%04x is not Fintek (should be '0x1934')\n", id);
		exit(1);
	}

	id = read_word(0x5a, 0x5b);
	if (id == 516) {
		printf("chip: F75373S; ", id);
	} else if (id == 774) {
		printf("chip: F75375S/SP; ", id);
	} else {
		printf("\nerror: chip id 0x%04x is not F75373S (should be '0x0204') or F75375S/SP (should be '0x0306')\n", id);
	}
	
	printf("interval: %dsec.\n", interval);
	
	
	while (1) {
		check_temp();
		sleep(interval);
	}
}
