// SplitCmdLine.cpp: CSplitCmdLine NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "SplitCmdLine.h"
#include "MainAr.h"
#include "Common/StdOutStream.h"

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CSplitCmdLine::CSplitCmdLine()
{
	m_argc = 0;
	m_argv = NULL;
	m_lpCmdLine = NULL;
	m_lpBaseDirectory = NULL;
	m_bHide = FALSE;
	m_bSfx = FALSE;
	m_bScs = FALSE;
}

CSplitCmdLine::~CSplitCmdLine()
{
	if (m_lpCmdLine)
		free(m_lpCmdLine);
	if (m_argv)
		free(m_argv);
}

BOOL CSplitCmdLine::Split(const wchar_t* lpCmdLine)
{
	// R}hC
	if (lpCmdLine)
		m_lpCmdLine = _wcsdup(lpCmdLine);
	else
		m_lpCmdLine = _wcsdup(L"");
	wchar_t* p = m_lpCmdLine;
	wchar_t* pStart;
	while (*p)
	{
		while (*p == ' ')
		{
			*p = '\0';
			++p;
		}
		if (*p == '\"')
		{
			pStart = p;
			++p;
			while (*p && !(*p == '\"' && (p[1] == ' ' || p[1] == '\0')))
				++p;
			if (*p == '\0')
				break;
			*pStart = '\0';
			*p = '\0';
			++p;
			++m_argc;
		}
		else if (*p != '\0')
		{
			while (*p && *p != ' ')
				++p;
			++m_argc;
		}
	}
	
	// R}hC蓖
	int i;
	m_argv = (wchar_t**)malloc((m_argc + 2) * sizeof(wchar_t*));
	p = m_lpCmdLine;
	BOOL bSkip = FALSE;
	m_bScs = FALSE;
	for (i = 0; i < m_argc; ++i)
	{
		while (*p == NULL)
			++p;
		if (*p == '/')
			*p = '-';
		if ((!_wcsicmp(p, L"-hide")) && !bSkip)
		{
			// \[h
			m_bHide = TRUE;
			--m_argc;
			--i;
		}
		else if ((!_wcsicmp(p, L"-sfx")) && !bSkip)
		{
			// SFX쐬
			m_bSfx = TRUE;
			--m_argc;
			--i;
		}
		else if (IsBaseDir(p))
		{
			// fBNgݒ
			m_lpBaseDirectory = p;
			--m_argc;
			--i;
		}
		else
		{
			if ((p[1] == 'S' || p[1] == 's') && (p[2] == 'C' || p[2] == 'c') && (p[3] == 'S' || p[3] == 's'))
			{
				// Xgt@C̕R[hw`FbN
				m_bScs = TRUE;
			}
			m_argv[i] = p;
			if (_wcsicmp(p, L"--") == 0)
				bSkip = TRUE;
		}
		while (*p)
			++p;
	}
	m_argv[i] = L"";

	if (*m_argv[0] == 'l' || *m_argv[0] == 't')
	{
		m_bHide = TRUE;
	}
	return TRUE;
}

// fBNg
BOOL CSplitCmdLine::IsBaseDir(const wchar_t* lpOption)
{
	if (*lpOption == '-' || *lpOption == '/')
		return FALSE;

	if (lpOption[wcslen(lpOption) - 1] == '\\')
		return TRUE;
	return FALSE;
}

// R}hɑñR}h(a,d,u)
BOOL CSplitCmdLine::IsUpdateCommands()
{
	return (_wcsicmp(m_argv[0], L"a") == 0 || _wcsicmp(m_argv[0], L"d") == 0 || _wcsicmp(m_argv[0], L"u") == 0);
}
