// 7-zip32.cpp : DLL AvP[Vp̃Gg |Cg`܂B
//
#include "stdafx.h"
#include "7-zip32.h"
#include "Dialog.h"
#include "MyOpenArchive.h"
#include "MainAr.h"
#include "SplitCmdLine.h"
#include "Common/StdOutStream.h"
#include "resource.h"
#include <process.h>

#include "Common/UTFConvert.h"
#include "Windows/FileDir.h"

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		{
			g_hInstance = (HINSTANCE)hModule;
			OSVERSIONINFO versionInfo;
			versionInfo.dwOSVersionInfoSize = sizeof(versionInfo);
			if (!::GetVersionEx(&versionInfo))
				g_IsNT = false;
			else
				g_IsNT = (versionInfo.dwPlatformId == VER_PLATFORM_WIN32_NT);
			break;
		}
	case DLL_PROCESS_DETACH:
		COpenArchive::RemoveAll();
		break;
	}
    return TRUE;
}

int WINAPI SevenZip(const HWND _hwnd, LPCSTR _szCmdLine, LPSTR _szOutput, const DWORD _dwSize)
{
	if (g_StdOut.m_hThread)
		return ERROR_ALREADY_RUNNING;

	CSplitCmdLine scl;
	UString strCmdLine;
	if (g_StdOut.GetUnicodeMode())
		::ConvertUTF8ToUnicode(_szCmdLine, strCmdLine);
	else
		strCmdLine = ::GetUnicodeString(_szCmdLine);
	if (!scl.Split(strCmdLine))
		return ERROR_COMMAND_NAME;

	if (scl.m_bSfx && scl.IsUpdateCommands())
	{
		CSfxDialog dlgSfx(_hwnd);
		if (dlgSfx.DoModal() == IDCANCEL)
			return ERROR_USER_CANCEL;
	}

	g_StdOut.SetCommandLine(scl);
	UString strCurrentDirectory;
	if (scl.m_lpBaseDirectory)
	{
		::NWindows::NFile::NDirectory::MyGetCurrentDirectory(strCurrentDirectory);
		if (::NWindows::NFile::NDirectory::MySetCurrentDirectory(scl.m_lpBaseDirectory) == false)
		{
			g_StdOut << "Base directory isn't found.";
			g_StdOut.CopyBuf(_szOutput, _dwSize);
			g_StdOut.ReSet();
			return ERROR_FATAL;
		}
	}

	UINT thrdaddr;
	g_StdOut.m_hThread = (HANDLE)_beginthreadex(NULL, 0, Main, (void*)&scl, CREATE_SUSPENDED, &thrdaddr);

	CProgressDialog dlgProgress(_hwnd);
	g_StdOut.SetProgressDialog(&dlgProgress);
	dlgProgress.SetShowDialog(!scl.m_bHide);
	dlgProgress.SetProgressMode(scl.m_argv[0][0]);
	dlgProgress.CreateModal();

	DWORD dwThreadId;
	::WaitForSingleObject(g_StdOut.m_hThread, INFINITE);
	::GetExitCodeThread(g_StdOut.m_hThread, &dwThreadId);
	::CloseHandle(g_StdOut.m_hThread);
	g_StdOut.CopyBuf(_szOutput, _dwSize);
	g_StdOut.ReSet();
	if (scl.m_bSfx)
		::NWindows::NFile::NDirectory::DeleteFileAlways(g_StdOut.GetTempSFXName());
	if (scl.m_lpBaseDirectory)
		::NWindows::NFile::NDirectory::MySetCurrentDirectory(strCurrentDirectory);
    return dwThreadId;
}

WORD WINAPI SevenZipGetVersion()
{
	return (SEVENZIP32_VERSION / 10000);
}

// {IɈӖȂ
static BOOL bCursorMode = FALSE;
static BOOL bBackGroundMode = FALSE;
static int  nCursorInterval = 80;
BOOL WINAPI SevenZipGetCursorMode() { return bCursorMode; }
BOOL WINAPI SevenZipSetCursorMode(const BOOL _CursorMode) { bCursorMode = _CursorMode; return TRUE; }
BOOL WINAPI SevenZipGetBackGroundMode() { return bBackGroundMode; }
BOOL WINAPI SevenZipSetBackGroundMode(const BOOL _BackGroundMode) { bBackGroundMode = _BackGroundMode; return TRUE; }
WORD WINAPI SevenZipGetCursorInterval() { return nCursorInterval; }
BOOL WINAPI SevenZipSetCursorInterval(const WORD _Interval) { nCursorInterval = _Interval; return TRUE; }

BOOL WINAPI SevenZipGetRunning()
{
	return (g_StdOut.m_hThread != NULL);
}

// Ăяo
BOOL WINAPI SevenZipConfigDialog(const HWND _hwnd, LPSTR _szOptionBuffer, const int _iMode)
{
	if (g_StdOut.m_hThread)
		return ERROR_ALREADY_RUNNING;
	CConfigDialog dlg(_hwnd);
	return dlg.DoModal();
}

BOOL WINAPI SevenZipCheckArchive(LPCSTR _szFileName, const int _iMode)
{
	UString strFile;
	if (g_StdOut.GetUnicodeMode())
		::ConvertUTF8ToUnicode(_szFileName, strFile);
	else
		strFile = ::GetUnicodeString(_szFileName);
	CArchiveLink archiveLink;
	int nArchiveType;
	return (COpenArchive::OpenCheck(strFile, _iMode, archiveLink, nArchiveType) == S_OK);
}

int WINAPI SevenZipGetFileCount(LPCSTR _szArcFile)
{
	HARC hArc = SevenZipOpenArchive(NULL, _szArcFile, 0);
	COpenArchive* pOpenArchive = COpenArchive::FindObject(hArc);
	if (pOpenArchive == NULL)
		return -1;
	int nCount = pOpenArchive->GetFileCount();
	SevenZipCloseArchive(hArc);
	return nCount;
}

BOOL WINAPI SevenZipQueryFunctionList(const int _iFunction)
{
	switch (_iFunction)
	{
	case ISARC:
	case ISARC_GET_VERSION:
	case ISARC_GET_CURSOR_INTERVAL:
	case ISARC_SET_CURSOR_INTERVAL:
	case ISARC_GET_BACK_GROUND_MODE:
	case ISARC_SET_BACK_GROUND_MODE:
	case ISARC_GET_CURSOR_MODE:
	case ISARC_SET_CURSOR_MODE:
	case ISARC_GET_RUNNING:
		
	case ISARC_CHECK_ARCHIVE:
	case ISARC_CONFIG_DIALOG:
	case ISARC_GET_FILE_COUNT:
	case ISARC_QUERY_FUNCTION_LIST:
//	case ISARC_HOUT:
//	case ISARC_STRUCTOUT:
//	case ISARC_GET_ARC_FILE_INFO:
		
	case ISARC_OPEN_ARCHIVE:
	case ISARC_CLOSE_ARCHIVE:
	case ISARC_FIND_FIRST:
	case ISARC_FIND_NEXT:
//	case ISARC_EXTRACT:
//	case ISARC_ADD:
//	case ISARC_MOVE:
//	case ISARC_DELETE:
	case ISARC_SETOWNERWINDOW:
	case ISARC_CLEAROWNERWINDOW:
	case ISARC_SETOWNERWINDOWEX:
	case ISARC_KILLOWNERWINDOWEX:
		
	case ISARC_GET_ARC_FILE_NAME:
	case ISARC_GET_ARC_FILE_SIZE:
	case ISARC_GET_ARC_ORIGINAL_SIZE:
	case ISARC_GET_ARC_COMPRESSED_SIZE:
	case ISARC_GET_ARC_RATIO:
	case ISARC_GET_ARC_DATE:
	case ISARC_GET_ARC_TIME:
//	case ISARC_GET_ARC_OS_TYPE:
//	case ISARC_GET_ARC_IS_SFX_FILE:
	case ISARC_GET_ARC_WRITE_TIME_EX:
	case ISARC_GET_ARC_CREATE_TIME_EX:
	case ISARC_GET_ARC_ACCESS_TIME_EX:
//	case ISARC_GET_ARC_CREATE_TIME_EX2:
//	case ISARC_GET_ARC_WRITE_TIME_EX2:
	case ISARC_GET_FILE_NAME:
	case ISARC_GET_ORIGINAL_SIZE:
	case ISARC_GET_COMPRESSED_SIZE:
	case ISARC_GET_RATIO:
	case ISARC_GET_DATE:
	case ISARC_GET_TIME:
	case ISARC_GET_CRC:
	case ISARC_GET_ATTRIBUTE:
//	case ISARC_GET_OS_TYPE:
	case ISARC_GET_METHOD:
	case ISARC_GET_WRITE_TIME:
	case ISARC_GET_CREATE_TIME:
	case ISARC_GET_ACCESS_TIME:
	case ISARC_GET_WRITE_TIME_EX:
	case ISARC_GET_CREATE_TIME_EX:
	case ISARC_GET_ACCESS_TIME_EX:
//	case ISARC_SET_ENUM_MEMBERS_PROC:
//	case ISARC_CLEAR_ENUM_MEMBERS_PROC:
	case ISARC_GET_ARC_FILE_SIZE_EX:
	case ISARC_GET_ARC_ORIGINAL_SIZE_EX:
	case ISARC_GET_ARC_COMPRESSED_SIZE_EX:
	case ISARC_GET_ORIGINAL_SIZE_EX:
	case ISARC_GET_COMPRESSED_SIZE_EX:
	case ISARC_SETOWNERWINDOWEX64:
	case ISARC_KILLOWNERWINDOWEX64:
//	case ISARC_SET_ENUM_MEMBERS_PROC64:
//	case ISARC_CLEAR_ENUM_MEMBERS_PROC64:
//	case ISARC_OPEN_ARCHIVE2:
//	case ISARC_GET_ARC_READ_SIZE:
//	case ISARC_GET_ARC_READ_SIZE_EX:
		return TRUE;
	default:
		break;
	}
	return FALSE;
}

// Ƃ肠_dwMode͕ۑĂ邯ǈӖ
HARC WINAPI SevenZipOpenArchive(const HWND _hwnd, LPCSTR _szFileName, const DWORD _dwMode)
{
	COpenArchive* pOpenArchive = new COpenArchive;
	if (pOpenArchive)
	{
		UString strFile;
		if (g_StdOut.GetUnicodeMode())
			::ConvertUTF8ToUnicode(_szFileName, strFile);
		else
			strFile = ::GetUnicodeString(_szFileName);
		if (pOpenArchive->Open(strFile, _dwMode) == FALSE)
		{
			delete pOpenArchive;
			return NULL;
		}
	}
	return (HARC)pOpenArchive;
}

int WINAPI SevenZipCloseArchive(HARC _harc)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return -1;
	delete pOpenArchive;
	return 0;
}

int WINAPI SevenZipFindFirst(HARC _harc, LPCSTR _szWildName, INDIVIDUALINFO *_lpSubInfo)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return ERROR_HARC_ISNOT_OPENED;
	return pOpenArchive->FindFirst(::GetUnicodeString(_szWildName), _lpSubInfo);
}

int WINAPI SevenZipFindNext(HARC _harc, INDIVIDUALINFO *_lpSubInfo)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return ERROR_NOT_SEARCH_MODE;
	return pOpenArchive->FindNext(_lpSubInfo);
}

int WINAPI SevenZipGetArcFileName(HARC _harc, LPSTR _lpBuffer, const int _nSize)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return ERROR_HARC_ISNOT_OPENED;
	g_StdOut.WideCharToMultiByte(pOpenArchive->GetArcFileName(), _lpBuffer, _nSize);
	return 0;
}

DWORD WINAPI SevenZipGetArcFileSize(HARC _harc)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return -1;
	return pOpenArchive->GetArcFileSize();
}

DWORD WINAPI SevenZipGetArcOriginalSize(HARC _harc)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return -1;
	return pOpenArchive->GetArcOriginalSize();
}

DWORD WINAPI SevenZipGetArcCompressedSize(HARC _harc)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return -1;
	return pOpenArchive->GetArcCompressedSize();
}

WORD WINAPI SevenZipGetArcRatio(HARC _harc)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return -1;
	return pOpenArchive->GetArcRatio();
}

WORD WINAPI SevenZipGetArcDate(HARC _harc)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return -1;
	return pOpenArchive->GetArcDate();
}

WORD WINAPI SevenZipGetArcTime(HARC _harc)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return -1;
	return pOpenArchive->GetArcTime();
}

// Gĝ݁BG[ȊOAK0Ԃ
UINT WINAPI SevenZipGetArcOSType(HARC _harc)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return -1;
	return pOpenArchive->GetArcOSType();
}

// Gĝ݁BG[ȊOAK0Ԃ
int WINAPI SevenZipIsSFXFile(HARC _harc)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return -1;
	return pOpenArchive->IsSFXFile();
}

int WINAPI SevenZipGetFileName(HARC _harc, LPSTR _lpBuffer, const int _nSize)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return ERROR_HARC_ISNOT_OPENED;
	LPCWSTR lpFileName = pOpenArchive->GetFileName();
	if (lpFileName == NULL)
		return ERROR_NOT_SEARCH_MODE;
	g_StdOut.WideCharToMultiByte(lpFileName, _lpBuffer, _nSize);
	return 0;
}

DWORD WINAPI SevenZipGetOriginalSize(HARC _harc)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return -1;
	return pOpenArchive->GetOriginalSize();
}

DWORD WINAPI SevenZipGetCompressedSize(HARC _harc)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return -1;
	return pOpenArchive->GetCompressedSize();
}

WORD WINAPI SevenZipGetRatio(HARC _harc)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return -1;
	return pOpenArchive->GetRatio();
}

WORD WINAPI SevenZipGetDate(HARC _harc)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return -1;
	return pOpenArchive->GetDate();
}

WORD WINAPI SevenZipGetTime(HARC _harc)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return -1;
	return pOpenArchive->GetTime();
}

DWORD WINAPI SevenZipGetCRC(HARC _harc)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return -1;
	return pOpenArchive->GetCRC();
}

int WINAPI SevenZipGetAttribute(HARC _harc)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return -1;
	return pOpenArchive->GetAttribute();
}

// Gĝ݁BG[ȊOAK0Ԃ
UINT WINAPI SevenZipGetOSType(HARC _harc)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return -1;
	return pOpenArchive->GetOSType();
}

int WINAPI SevenZipGetMethod(HARC _harc, LPSTR _lpBuffer, const int _nSize)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return ERROR_HARC_ISNOT_OPENED;
	LPCWSTR lpMethod = pOpenArchive->GetMethod();
	if (lpMethod == NULL)
		return ERROR_NOT_SEARCH_MODE;
	g_StdOut.WideCharToMultiByte(lpMethod, _lpBuffer, _nSize);
	if (_nSize == 8 && pOpenArchive->GetArchiveType() == ARCHIVETYPE_7Z)
		_lpBuffer[strcspn(_lpBuffer, " :")] = '\0';
	return 0;
}

DWORD WINAPI SevenZipGetWriteTime(HARC _harc)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return -1;
	return pOpenArchive->GetWriteTime();
}

DWORD WINAPI SevenZipGetCreateTime(HARC _harc)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return -1;
	return pOpenArchive->GetCreateTime();
}

DWORD WINAPI SevenZipGetAccessTime(HARC _harc)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return -1;
	return pOpenArchive->GetAccessTime();
}

BOOL WINAPI SevenZipGetWriteTimeEx(HARC _harc, FILETIME *_lpftLastWriteTime)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return FALSE;
	return pOpenArchive->GetWriteTimeEx(_lpftLastWriteTime);
}

BOOL WINAPI SevenZipGetCreateTimeEx(HARC _harc, FILETIME *_lpftLastWriteTime)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return FALSE;
	return pOpenArchive->GetCreateTimeEx(_lpftLastWriteTime);
}

BOOL WINAPI SevenZipGetAccessTimeEx(HARC _harc, FILETIME *_lpftLastWriteTime)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return FALSE;
	return pOpenArchive->GetAccessTimeEx(_lpftLastWriteTime);
}

BOOL WINAPI SevenZipGetArcCreateTimeEx(HARC _harc, FILETIME *_lpftCreationTime)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return FALSE;
	return pOpenArchive->GetArcCreateTimeEx(_lpftCreationTime);
}

BOOL WINAPI SevenZipGetArcAccessTimeEx(HARC _harc, FILETIME *_lpftLastAccessTime)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return FALSE;
	return pOpenArchive->GetArcAccessTimeEx(_lpftLastAccessTime);
}

BOOL WINAPI SevenZipGetArcWriteTimeEx(HARC _harc, FILETIME *_lpftLastWriteTime)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return FALSE;
	return pOpenArchive->GetArcWriteTimeEx(_lpftLastWriteTime);
}

BOOL WINAPI SevenZipGetArcFileSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return FALSE;
	return pOpenArchive->GetArcFileSizeEx(_lpllSize);
}

BOOL WINAPI SevenZipGetArcOriginalSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return FALSE;
	return pOpenArchive->GetArcOriginalSizeEx(_lpllSize);
}

BOOL WINAPI SevenZipGetArcCompressedSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return FALSE;
	return pOpenArchive->GetArcCompressedSizeEx(_lpllSize);
}

BOOL WINAPI SevenZipGetOriginalSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return FALSE;
	return pOpenArchive->GetOriginalSizeEx(_lpllSize);
}

BOOL  WINAPI SevenZipGetCompressedSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	COpenArchive* pOpenArchive = COpenArchive::FindObject(_harc);
	if (pOpenArchive == NULL)
		return FALSE;
	return pOpenArchive->GetCompressedSizeEx(_lpllSize);
}

BOOL WINAPI SevenZipSetOwnerWindow(HWND _hwnd)
{
	return CProgressDialog::SetOwnerWindow(_hwnd);
}

BOOL WINAPI SevenZipClearOwnerWindow()
{
	return CProgressDialog::ClearOwnerWindow();
}

BOOL WINAPI SevenZipSetOwnerWindowEx(HWND _hwnd, LPARCHIVERPROC _lpArcProc)
{
	return CProgressDialog::SetOwnerWindowEx(_hwnd, _lpArcProc);
}

BOOL WINAPI SevenZipKillOwnerWindowEx(HWND _hwnd)
{
	return CProgressDialog::KillOwnerWindowEx(_hwnd);
}

BOOL WINAPI SevenZipSetOwnerWindowEx64(HWND _hwnd, LPARCHIVERPROC _lpArcProc, DWORD _dwStructSize)
{
	return CProgressDialog::SetOwnerWindowEx64(_hwnd, _lpArcProc, _dwStructSize);
}

BOOL WINAPI SevenZipKillOwnerWindowEx64(HWND _hwnd)
{
	return CProgressDialog::KillOwnerWindowEx64(_hwnd);
}

WORD WINAPI SevenZipGetSubVersion()
{
	return (SEVENZIP32_VERSION % 10000);
}

int WINAPI SevenZipGetArchiveType(LPCSTR _szFileName)
{
	UString strFile;
	if (g_StdOut.GetUnicodeMode())
		::ConvertUTF8ToUnicode(_szFileName, strFile);
	else
		strFile = ::GetUnicodeString(_szFileName);
	CArchiveLink archiveLink;
	int nArchiveType;
	HRESULT result = COpenArchive::OpenCheck(strFile, CHECKARCHIVE_RAPID, archiveLink, nArchiveType);
	switch (result)
	{
	case S_OK:
		break;
	case E_FAIL:
		return -1;
	default:
		return 0;
	}
	return nArchiveType;
}

BOOL WINAPI SevenZipSetUnicodeMode(BOOL _bUnicode)
{
	return g_StdOut.SetUnicodeMode(_bUnicode);
}