// Common/StdOutStream.cpp

#include "StdAfx.h"

#include "StdOutStream.h"
#include "Common/IntToString.h"
#include "Common/StringConvert.h"
#include "Common/UTFConvert.h"
#include "Windows/FileDir.h"

static const char kNewLineChar =  '\n';

CStdOutStream  g_StdOut;
CStdOutStream  g_StdErr;

CStdOutStream ::CStdOutStream ()
{
	_streamIsOpen = false;
	_stream = stdout;
	m_strLog = L"";
	m_lpCommandLine = NULL;
	m_bUnicode = 0;
	*m_lpTempSFXName = '\0';
	ReSet();
}

CStdOutStream ::~CStdOutStream ()
{
	if (m_lpCommandLine)
		free(m_lpCommandLine);
}

CStdOutStream & CStdOutStream::operator<<(CStdOutStream & (*aFunction)(CStdOutStream  &))
{
  (*aFunction)(*this);    
  return *this;
}

CStdOutStream & endl(CStdOutStream & outStream)
{
  return outStream << kNewLineChar;
}

CStdOutStream & CStdOutStream::operator<<(const char *string)
{
	m_strLog += GetUnicodeString(string);
	return *this;
}

CStdOutStream & CStdOutStream::operator<<(const wchar_t *string)
{
	m_strLog += string;
	return *this;
}

CStdOutStream & CStdOutStream::operator<<(char c)
{
	m_strLog += c;
	return *this;
}

CStdOutStream & CStdOutStream::operator<<(int number)
{
	char textString[32];
	ConvertInt64ToString(number, textString);
	return operator<<(textString);
}

CStdOutStream & CStdOutStream::operator<<(UINT64 number)
{
  char textString[32];
  ConvertInt64ToString(number, textString);
  return operator<<(textString);
}

// oϐ
void CStdOutStream::ReSet()
{
	m_pDlgProgress = NULL;
	m_hThread = NULL;
	m_strLog.Empty();
	if (m_lpCommandLine)
	{
		free(m_lpCommandLine);
		m_lpCommandLine = NULL;
	}
}

// o͂Rs[
// lpCopyBufNULL̎͏o̓obt@̃|C^̂Ԃ
void CStdOutStream::CopyBuf(LPSTR lpCopyBuf, DWORD dwBufSize)
{
	if (lpCopyBuf == NULL)
		return;

	AString strLog;
	if (m_bUnicode)
		::ConvertUnicodeToUTF8(m_strLog, strLog);
	else
		strLog = GetOemString(m_strLog);
	strLog.Replace("\n", "\r\n");
	strncpy(lpCopyBuf, strLog, dwBufSize);
	lpCopyBuf[dwBufSize - 1] = '\0';
}

// ꂽR}hR}hCɂċL
void CStdOutStream::SetCommandLine(const CSplitCmdLine& scl)
{
	UString strCmdLine = L"7-zip32.dll ";
	strCmdLine += scl.m_argv[0];
	if (scl.m_bSfx)
	{
		strCmdLine += L" \"-sfx";
		strCmdLine += GetTempSFXName();
		strCmdLine += L"\"";
	}
	if (!scl.m_bScs && !m_bUnicode && scl.m_argc > 0)
		strCmdLine += L" -scsWIN";

	for (int i = 1; i < scl.m_argc; ++i)
	{
		strCmdLine += L" \"";
		strCmdLine += scl.m_argv[i];
		strCmdLine += L"\"";
	}
	if (m_lpCommandLine)
		free(m_lpCommandLine);
	m_lpCommandLine = _wcsdup(strCmdLine);
}

// ꎞSFXt@C̎擾
LPCWSTR CStdOutStream::GetTempSFXName()
{
	if (*m_lpTempSFXName == '\0')
	{
		UString strTempPath;
		UString strTempFile;
		::NWindows::NFile::NDirectory::MyGetTempPath(strTempPath);
		::NWindows::NFile::NDirectory::MyGetTempFileName(strTempPath, L"sfx", strTempFile);
		wcsncpy(m_lpTempSFXName, strTempFile, MAX_PATH);
		m_lpTempSFXName[MAX_PATH - 1] = '\0';
	}
	return m_lpTempSFXName;
}

// WCHAR[hɕcharɕϊăRs[
void CStdOutStream::WideCharToMultiByte(const UString &strWideChar, LPSTR lpMultiByteStr, int cchMultiByte)
{
	if (m_bUnicode)
	{
		AString strUtf8;
		::ConvertUnicodeToUTF8(strWideChar, strUtf8);
		::lstrcpynA(lpMultiByteStr, strUtf8, cchMultiByte);
	}
	else
		::lstrcpynA(lpMultiByteStr, ::GetOemString(strWideChar), cchMultiByte);
}

// t@C𕶎ɕϊ
void CStdOutStream::GetAttributesString(DWORD dwAttributes, bool bEncrypt, LPSTR lpAttributes)
{
	lpAttributes[0] = (dwAttributes & FILE_ATTRIBUTE_ARCHIVE)  ? 'A' : '-';
	lpAttributes[1] = (dwAttributes & FILE_ATTRIBUTE_SYSTEM)   ? 'S' : '-';
	lpAttributes[2] = (dwAttributes & FILE_ATTRIBUTE_HIDDEN)   ? 'H' : '-';
	lpAttributes[3] = (dwAttributes & FILE_ATTRIBUTE_READONLY) ? 'R' : 'W';
	if (bEncrypt)
	{
		lpAttributes[4] = (dwAttributes & FA_ENCRYPTED) ? 'G' : '-';
		lpAttributes[5] = '\0';
		return;
	}
	lpAttributes[4] = '\0';
}

// k8oCgcharzɓ悤Zϊ(lpMethodASCIÎݑO)
void CStdOutStream::GetCompactMethod(LPCWSTR lpMethod, int nArchiveType, LPSTR lpCompactMethod)
{
	switch (nArchiveType)
	{
	case ARCHIVETYPE_7Z:
		{
			for (int i = 0; i < 7; ++i)
			{
				lpCompactMethod[i] = lpMethod[i];
				if (lpCompactMethod[i] == ' ' || lpCompactMethod[i] == ':' || lpCompactMethod[i] == '\0')
					break;
			}
			lpCompactMethod[i] = '\0';
			break;
		}
	case ARCHIVETYPE_ZIP:
		{
			for (LPCWSTR p = lpMethod; *p != '\0'; ++p)
			{
				if (*p == ' ')
					lpMethod = ++p;
			}
			int i;
			for (i = 0; i < 8; ++i)
			{
				lpCompactMethod[i] = lpMethod[i];
				if (lpCompactMethod[i] == '\0')
					break;
			}
			if (i == 8)
			{
				switch (lpMethod[7])
				{
				case '1':	// Reduced1 -> Reduce1
				case '2':	// Reduced2 -> Reduce2
				case '3':	// Reduced3 -> Reduce3
					lpCompactMethod[6] = lpMethod[7];
					lpCompactMethod[7] = '\0';
					break;
				case '6':	// Deflate64 -> Defla64
					lpCompactMethod[5] = '6';
					lpCompactMethod[6] = '4';
					lpCompactMethod[7] = '\0';
					break;
				case 'i':	// Tokenizing -> Tokeniz
				case 'd':	// PKImploding -> PKImplo
				default:	// s -> O7܂
					lpCompactMethod[7] = '\0';
					break;
				}
			}
			break;
		}
	default:
		lpCompactMethod[0] = '\0';
		break;
	}
}