// Common/StdOutStream.h

#pragma once 

#ifndef __COMMON_STDOUTSTREAM_H
#define __COMMON_STDOUTSTREAM_H

#include "../7-zip32.h"
#include "../Dialog.h"
#include "../SplitCmdLine.h"

class CStdOutStream
{
	bool _streamIsOpen;
	FILE *_stream;
public:
	static void GetCompactMethod(LPCWSTR lpMethod, int nArchiveType, LPSTR lpCompactMethod);
	static void GetAttributesString(DWORD dwAttributes, bool bEncrypt, LPSTR lpAttributes);

	HANDLE m_hThread;

	LPCWSTR GetTempSFXName();
	void SetCommandLine(const CSplitCmdLine& scl);
	void CopyBuf(LPSTR lpCopyBuf, DWORD dwBufSize);
	void ReSet();
	void WideCharToMultiByte(const UString &strWideChar, LPSTR lpMultiByteStr, int cchMultiByte);

	CProgressDialog* GetProgressDialog() { return m_pDlgProgress; }
	void CloseProgressDialog() { ::PostMessage(m_pDlgProgress->m_hWnd, WM_CLOSE, 0, 1); }
	void SetProgressDialog(CProgressDialog* pDlg) { m_pDlgProgress = pDlg; }
	BOOL SetUnicodeMode(BOOL bUnicode)
	{ 
		if (m_hThread)
			return FALSE;
		m_bUnicode = bUnicode;
		return TRUE;
	}
	BOOL GetUnicodeMode() { return m_bUnicode; }
	LPWSTR GetCommandLineW() { return m_lpCommandLine; }

	CStdOutStream ();
	CStdOutStream (FILE *stream): _streamIsOpen(false), _stream(stream) {};
	~CStdOutStream ();
	operator FILE *() { return _stream; }
	bool Flush() { return true; }
	
	CStdOutStream & operator<<(CStdOutStream & (* aFunction)(CStdOutStream  &));
	CStdOutStream & operator<<(const char *string);
	CStdOutStream & operator<<(const wchar_t *string);
	CStdOutStream & operator<<(char c);
	CStdOutStream & operator<<(int number);
	CStdOutStream & operator<<(UInt64 number);

protected:
	LPWSTR m_lpCommandLine;
	WCHAR m_lpTempSFXName[MAX_PATH];
	CProgressDialog* m_pDlgProgress;
	BOOL m_bUnicode;
	UString m_strLog;
};

CStdOutStream & endl(CStdOutStream & anOut);

extern CStdOutStream g_StdOut;
extern CStdOutStream g_StdErr;

#endif
