/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.pdf_brewer.instruction;

import java.io.IOException;
import java.util.List;
import net.osdn.pdf_brewer.Context;
import net.osdn.pdf_brewer.PdfBrewer;
import net.osdn.pdf_brewer.instruction.Instruction;

public class LineStyle
extends Instruction {
    public static final float WIDTH_THIN = 0.33333334f;
    public static final float WIDTH_MEDIUM = 0.6666667f;
    public static final float WIDTH_THICK = 1.3333334f;
    public static final int LINE_SOLID = 0;
    public static final int LINE_DOTTED = 1;
    public static final int LINE_DASHED = 2;
    public static final int CAP_DEFAULT = -1;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_PROJECTING_SQUARE = 2;
    private float lineWidth = Float.NaN;
    private int capStyle = -1;
    private int lineStyle = 0;

    public LineStyle(int indent, List<Object> params) {
        super(indent, params);
        for (int i = 0; i < params.size(); ++i) {
            Object obj = params.get(i);
            if (obj instanceof Number) {
                this.lineWidth = ((Number)obj).floatValue();
                continue;
            }
            if (!(obj instanceof String)) continue;
            String s = ((String)obj).toLowerCase();
            if (s.equals("thin")) {
                this.lineWidth = 0.33333334f;
                continue;
            }
            if (s.equals("medium")) {
                this.lineWidth = 0.6666667f;
                continue;
            }
            if (s.equals("thick")) {
                this.lineWidth = 1.3333334f;
                continue;
            }
            if (s.contains("butt")) {
                this.capStyle = 0;
                continue;
            }
            if (s.contains("round")) {
                this.capStyle = 1;
                continue;
            }
            if (s.contains("project") || s.contains("square")) {
                this.capStyle = 2;
                continue;
            }
            if (s.contains("solid")) {
                this.lineStyle = 0;
                continue;
            }
            if (s.contains("dot")) {
                this.lineStyle = 1;
                continue;
            }
            if (!s.contains("dash")) continue;
            this.lineStyle = 2;
        }
    }

    @Override
    public void process(PdfBrewer brewer, Context context) throws IOException {
        if (this.lineWidth != Float.NaN && (double)this.lineWidth >= 0.0) {
            context.setLineWidth(this.lineWidth);
        }
        if (this.lineStyle == 0 || this.lineStyle == 1 || this.lineStyle == 2) {
            context.setLineStyle(this.lineStyle);
        }
        if (this.capStyle == 0 || this.capStyle == 1 || this.capStyle == 2) {
            context.setCapStyle(this.capStyle);
        } else {
            context.setCapStyle(-1);
        }
    }
}

