#include <string.h>
#include <stdlib.h>
#include "context.h"
#include "siod.h"

extern LISP sym_t;
char *uim_return_str;

static void
uim_flush_cb(uim_context uc)
{
  struct cb *cb = uc->cb_q.first_cb;
  while (cb) {
    struct cb *tmp = cb;
    cb = cb->next;
    switch (tmp->type) {
    case COMMIT_CB:
      {
	char *s;
	s = uim_code_conv(tmp->str, uc->conv);
 	if (uc->commit_cb) {
 	  uc->commit_cb(uc->ptr, s);
 	}
	free(s);
      }
      break;
    case CAND_BEGIN_CB:
      {
	if (uc->candidate_begin_cb) {
	  uc->candidate_begin_cb(uc->ptr, tmp->n1, tmp->n2);
	}
      }
      break;
    case CAND_UPDATE_CB:
      {
	if (uc->candidate_update_cb) {
	  uc->candidate_update_cb(uc->ptr, tmp->n1);
	}
      }
      break;
    case CAND_END_CB:
      {
	if (uc->candidate_end_cb) {
	  uc->candidate_end_cb(uc->ptr);
	}
      }
      break;
    case PREEDIT_CLEAR_CB:
      {
	if (uc->preedit_clear_cb) {
	  uc->preedit_clear_cb(uc->ptr);
	}
      }
      break;
    case PREEDIT_PUSHBACK_CB:
      {
	char *s;
	s = uim_code_conv(tmp->str, uc->conv);
	if (uc->preedit_pushback_cb) {
	  uc->preedit_pushback_cb(uc->ptr, tmp->n1, s);
	}
	free(s);

      }
      break;
    case PREEDIT_UPDATE_CB:
      {
	if (uc->preedit_update_cb) {
	  uc->preedit_update_cb(uc->ptr);
	}
      }
      break;
    case MODE_UPDATE_CB:
      {
	if (uc->mode_update_cb) {
	  uc->mode_update_cb(uc->ptr, tmp->n1);
	}
      }
      break;
    case MODE_LIST_UPDATE_CB:
      {
	if (uc->mode_list_update_cb) {
	  uc->mode_list_update_cb(uc->ptr);
	}
      }
    default:;
    }
    if (tmp->str) {
      free(tmp->str);
    }
    free(tmp);
  }
  uc->cb_q.first_cb = NULL;
  uc->cb_q.tail_cb = NULL;
}

char *
uim_code_conv(char *str, iconv_t ic)
{

  if(!str)
    return NULL;

  int len = strlen(str);
  int buflen = len * 6+3;
  char *realbuf = alloca(buflen);
  char *outbuf = realbuf;
  char *inbuf = str;
  if (!ic) {
    return strdup(str);
  }
  bzero(realbuf, buflen);
  iconv(ic,&inbuf,&len,&outbuf,&buflen);
  return strdup(realbuf);
}

void
uim_schedule_cb(uim_context uc, int type, char *str, int n1, int n2)
{
  struct cb *cb = malloc(sizeof(struct cb));
  cb->type = type;
  cb->str = str;
  cb->n1 = n1;
  cb->n2 = n2;
  cb->next = NULL;

  if (!uc->cb_q.first_cb) {
    uc->cb_q.first_cb = cb;
  }
  if (uc->cb_q.tail_cb) {
    uc->cb_q.tail_cb->next = cb;
  }
  uc->cb_q.tail_cb = cb;
}
void
uim_eval_string(uim_context uc, char *buf)
{
  repl_c_string(buf,0,0,1);
  if (!uc->cb_q.flushing) {
    uc->cb_q.flushing ++;
    uim_flush_cb(uc);
    uc->cb_q.flushing --;
  }
}

static LISP
im_clear_preedit(LISP id)
{
  uim_context uc = uim_find_context(get_c_long(id));
  uim_schedule_cb(uc, PREEDIT_CLEAR_CB, NULL, 0, 0);
  return NIL;
}

static LISP
im_pushback_preedit(LISP id_, LISP attr_, LISP str_)
{
  uim_context uc = uim_find_context(get_c_long(id_));
  char *str = NULL;
  int attr = get_c_long(attr_);
  if (str_) {
    str = uim_get_c_string(str_);
  }
  uim_schedule_cb(uc, PREEDIT_PUSHBACK_CB, str, attr, 0);
  return NIL;
}

static LISP
im_update_preedit(LISP id)
{
  uim_context uc = uim_find_context(get_c_long(id));
  uim_schedule_cb(uc, PREEDIT_UPDATE_CB, NULL, 0, 0);
  return NIL;
}

/* ID, STR */
static LISP
im_commit(LISP id, LISP str_)
{
  uim_context uc = uim_find_context(get_c_long(id));
  char *str = NULL;
  if (str_) {
    str = uim_get_c_string(str_);
  }
  uim_schedule_cb(uc, COMMIT_CB, str, 0, 0);
  return NIL;
}

static LISP
im_commit_raw(LISP id)
{
  uim_context uc = uim_find_context(get_c_long(id));
  uc->commit_raw_flag = 1;
  return NIL;
}

static LISP
im_set_encoding(LISP id, LISP enc)
{
  char *e = uim_get_c_string(enc);
  uim_context uc = uim_find_context(get_c_long(id));
  if (uc->conv) {
    iconv_close(uc->conv);
  }
  if (!strcmp(uc->encoding, e)) {
    free(e);
    uc->conv = 0;
    return NIL;
  }
  uc->conv = iconv_open(uc->encoding, e);
  free(e);
  if (uc->conv == (iconv_t)-1) {
    uc->conv = 0;
  }
  return NIL;
}

static LISP
im_clear_mode_list(LISP id)
{
  int i;
  uim_context uc = uim_find_context(get_c_long(id));
  for (i = 0; i < uc->nr_modes; i++) {
    if (uc->modes[i]) {
      free(uc->modes[i]);
    }
  }
  if (uc->modes) {
    free(uc->modes);
    uc->modes = NULL;
  }
  uc->nr_modes = 0;
  return NIL;
}

static LISP
im_pushback_mode_list(LISP id, LISP str)
{
  char *s;
  uim_context uc = uim_find_context(get_c_long(id));
  uc->modes = realloc(uc->modes,
		      sizeof(char *)*(uc->nr_modes+1));
  s = uim_get_c_string(str);
  uc->modes[uc->nr_modes] = uim_code_conv(s, uc->conv);
  free(s);
  uc->nr_modes ++;
  return NIL;
}

static LISP
im_update_mode_list(LISP id)
{
  uim_context uc = uim_find_context(get_c_long(id));
  uim_schedule_cb(uc, MODE_LIST_UPDATE_CB, NULL, 0, 0);
  return NIL;
}

static LISP
im_update_mode(LISP id, LISP mode_)
{
  int mode = get_c_long(mode_);
  uim_context uc = uim_find_context(get_c_long(id));
  uc->mode = mode;
  uim_schedule_cb(uc, MODE_UPDATE_CB, NULL, mode, 0);
  return NIL;
}

static char *
get_im_lang(char *name)
{
  int i;
  for (i = 0; i < uim_nr_im; i++) {
    struct uim_im *im = &uim_im_array[i];
    if (!strcmp(im->name, name)) {
      return im->lang;
    }
  }
  return NULL;
}

static LISP
im_register_im(LISP name, LISP lang, LISP enc)
{
  char *im_name = uim_get_c_string(name);
  char *lang_name = uim_get_c_string(lang);
  char *encoding_name = uim_get_c_string(enc);
  if (get_im_lang(im_name)) {
    // avoid double register
    free(lang_name);
    free(im_name);
    free(encoding_name);
    return NIL;
  }
  uim_im_array = realloc(uim_im_array,
			 sizeof(struct uim_im) *
			 (uim_nr_im + 1));
  uim_im_array[uim_nr_im].lang = strdup(lang_name);
  uim_im_array[uim_nr_im].name = strdup(im_name);
  uim_im_array[uim_nr_im].encoding = strdup(encoding_name);
  uim_nr_im ++;
  free(lang_name);
  free(im_name);
  free(encoding_name);
  return sym_t;
}

static LISP
im_begin_candidate(LISP id_, LISP nr_, LISP idx_)
{
  int id = get_c_long(id_);
  int idx = get_c_long(idx_);
  int nr = get_c_long(nr_);
  uim_context uc = uim_find_context(id);
  uim_schedule_cb(uc, CAND_BEGIN_CB, NULL, nr, idx);
  return NIL;
}

static LISP
im_update_candidate(LISP id_, LISP idx_)
{
  int id = get_c_long(id_);
  int idx = get_c_long(idx_);
  uim_context uc = uim_find_context(id);
  uim_schedule_cb(uc, CAND_UPDATE_CB, NULL, idx, 0);
  return NIL;
}

static LISP
im_end_candidate(LISP id_)
{
  int id = get_c_long(id_);
  uim_context uc = uim_find_context(id);
  uim_schedule_cb(uc, CAND_END_CB, NULL, 0, 0);
  return NIL;
}

static LISP
im_return_str(LISP str_)
{
  if (uim_return_str) {
    free(uim_return_str);
    uim_return_str = NULL;
  }
  if (str_ != NIL) {
    uim_return_str = uim_get_c_string(str_);
  }
  return NIL;
}

void
uim_init_im_subrs()
{
  /**/
  init_subr_1("im-return-str", im_return_str);
  /**/
  init_subr_2("im-commit", im_commit);
  init_subr_1("im-commit-raw", im_commit_raw);
  init_subr_2("im-set-encoding", im_set_encoding);
  /**/
  init_subr_3("im-register-im", im_register_im);
  /**/
  init_subr_1("im-clear-preedit", im_clear_preedit);
  init_subr_3("im-pushback-preedit", im_pushback_preedit);
  init_subr_1("im-update-preedit", im_update_preedit);
  /**/
  init_subr_1("im-clear-mode-list", im_clear_mode_list);
  init_subr_2("im-pushback-mode-list", im_pushback_mode_list);
  init_subr_1("im-update-mode-list", im_update_mode_list);
  /**/
  init_subr_2("im-update-mode", im_update_mode);
  /**/
  init_subr_3("im-begin-candidate", im_begin_candidate);
  init_subr_2("im-update-candidate", im_update_candidate);
  init_subr_1("im-end-candidate", im_end_candidate);
}
