package net.sf.amateras.air.wizards;

import java.util.Map;

import net.sf.amateras.air.natures.AIRFlexProjectNature;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;

/**
 * 
 * @author Naoki Takezoe
 */
public class NewAIRFlexProjectWizard extends AbstractNewAIRProjectWizard {

	public NewAIRFlexProjectWizard() {
		setWindowTitle("New AIR Flex Project");
	}

	@Override
	@SuppressWarnings("unchecked")
	protected void addProjectSpecificParameters(Map params) {
		String mainSWF = ((AIRFlexProjectPropertiesWizardPage) page2).getMainSWF();
		params.put("mainSWF", mainSWF);
		params.put("mainAS", mainSWF.replaceFirst("\\.swf$", ".as"));
	}

	@Override
	protected AIRProjectWizardPage createPage1() {
		AIRProjectWizardPage page = new AIRProjectWizardPage("New Flex AIR Application Project",
				AIRProjectWizardPage.FLEX_PROJECT);
		page.setTitle("New Flex AIR Application Project");
		page.setDescription("Create new Flex based AIR application project.");
		return page;
	}

	@Override
	protected AbstractAIRProjectPropertiesWizardPage createPage2() {
		AIRFlexProjectPropertiesWizardPage page = new AIRFlexProjectPropertiesWizardPage(
				"Flex Project Properties");
		page.setTitle("Flex Project Properties");
		page.setDescription("Input your project properties.");
		return page;
	}

	@Override
	protected void createProjectSpecificResources(IProject project, Map params,
			IProgressMonitor monitor) throws Exception {
		// make required files
		createFile(project, "application.xml", NewAIRFlexProjectWizard.class
				.getResourceAsStream("application_flex.xml"), params, monitor);

		// make main mxml
		createFile(project, ((String) params.get("mainSWF")).replaceFirst("\\.swf$", ".mxml"),
				NewAIRFlexProjectWizard.class.getResourceAsStream("main.mxml"), params, monitor);
		createFile(project, (String) params.get("mainAS"), NewAIRFlexProjectWizard.class
				.getResourceAsStream("main.as"), params, monitor);
	}

	@Override
	protected String getNatureId() {
		return AIRFlexProjectNature.NATURE_ID;
	}

}
