package net.sf.amateras.air.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;

import net.sf.amateras.air.AIRPlugin;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.WizardPage;

public abstract class AbstractNewAIRProjectWizard extends AbstractNewProjectWizard {

	String icon16;
	String icon32;
	String icon48;
	String icon128;

	protected Map createParamMap(WizardPage page) {
		final Map<String, String> params = new HashMap<String, String>();
		if (page instanceof AbstractAIRProjectPropertiesWizardPage) {
			AbstractAIRProjectPropertiesWizardPage wpage = (AbstractAIRProjectPropertiesWizardPage) page2;
			String applicationId = wpage.getApplicationId();
			String applicationName = wpage.getApplicationName();
			String applicationDescription = wpage.getApplicationDescription();
			String copyright = wpage.getCopyright();

			icon16 = wpage.getIcon16();
			icon32 = wpage.getIcon32();
			icon48 = wpage.getIcon48();
			icon128 = wpage.getIcon128();

			params.put("applicationId", applicationId);
			params.put("applicationName", applicationName);
			params.put("description", applicationDescription);
			params.put("copyright", copyright);
			params.put("icon_16", new File(icon16).getName());
			params.put("icon_32", new File(icon32).getName());
			params.put("icon_48", new File(icon48).getName());
			params.put("icon_128", new File(icon128).getName());
		}
		return params;
	}

	protected void createResource(IProject newProjectHandle, IProgressMonitor monitor, Map params) {
		try {
			// copy icons
			IFolder icons = newProjectHandle.getFolder("icons");
			icons.create(true, true, monitor);

			if (icon16.length() > 0) {
				createFile(newProjectHandle, "icons/" + params.get("icon_16"), new FileInputStream(
						icon16), null, monitor);
			}
			if (icon32.length() > 0) {
				createFile(newProjectHandle, "icons/" + params.get("icon_32"), new FileInputStream(
						icon32), null, monitor);
			}
			if (icon48.length() > 0) {
				createFile(newProjectHandle, "icons/" + params.get("icon_48"), new FileInputStream(
						icon48), null, monitor);
			}
			if (icon128.length() > 0) {
				createFile(newProjectHandle, "icons/" + params.get("icon_128"),
						new FileInputStream(icon128), null, monitor);
			}

			createProjectSpecificResources(newProjectHandle, params, monitor);

		} catch (Exception ex) {
			AIRPlugin.logException(ex);
		}
	}
}
