package net.sf.amateras.air.wizards;

import java.io.File;

import net.sf.amateras.air.util.ProcessUtil;
import net.sf.amateras.air.util.UIUtil;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

/**
 * 
 * @author Naoki Takezoe
 */
public abstract class AbstractAIRProjectPropertiesWizardPage extends WizardPage {

	private Text applicationId;
	private Text applicationName;
	private Text description;
	private Text copyright;
	private Text icon16;
	private Text icon32;
	private Text icon48;
	private Text icon128;

	private int projectType;

	/**
	 * Constructor.
	 * 
	 * @param pageName the page name
	 * @param projectType {@link AIRProjectWizardPage#HTML_PROJECT} or
	 *     {@link AIRProjectWizardPage#FLEX_PROJECT}
	 */
	protected AbstractAIRProjectPropertiesWizardPage(String pageName, int projectType) {
		super(pageName);
		this.projectType = projectType;
	}

	protected abstract void createProjectDependsFields(Composite parent);

	protected void projectNameChanged(String projectName) {
		applicationId.setText(projectName.replaceAll("[-_]", "")); // TODO appId is required and format check
		applicationName.setText(projectName);
	}

	protected int getProjectType() {
		return projectType;
	}

	public void createControl(Composite parent) {
		String sdkPath = ProcessUtil.getAirSdkPath();
		

		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(2, false));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));

		UIUtil.createLabel("ID", composite);
		applicationId = new Text(composite, SWT.BORDER);
		applicationId.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		UIUtil.createLabel("Name", composite);
		applicationName = new Text(composite, SWT.BORDER);
		applicationName.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		UIUtil.createLabel("Description", composite);
		description = new Text(composite, SWT.BORDER | SWT.MULTI);
		description.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		UIUtil.createLabel("Copyright", composite);
		copyright = new Text(composite, SWT.BORDER);
		copyright.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		createProjectDependsFields(composite);

		Group icons = new Group(composite, SWT.NULL);
		icons.setText("Icons");
		icons.setLayout(new GridLayout(3, false));
		icons.setLayoutData(UIUtil.createGridData(2));

		UIUtil.createLabel("16 x 16", icons);
		icon16 = new Text(icons, SWT.BORDER);
		icon16.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		icon16.setText(getFileAbsolutePath(sdkPath, "samples/icons/AIRApp_16.png"));
		UIUtil.createBrowseFileButton(icon16, icons);

		UIUtil.createLabel("32 x 32", icons);
		icon32 = new Text(icons, SWT.BORDER);
		icon32.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		icon32.setText(getFileAbsolutePath(sdkPath, "samples/icons/AIRApp_32.png"));
		UIUtil.createBrowseFileButton(icon32, icons);

		UIUtil.createLabel("48 x 48", icons);
		icon48 = new Text(icons, SWT.BORDER);
		icon48.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		icon48.setText(getFileAbsolutePath(sdkPath, "samples/icons/AIRApp_48.png"));
		UIUtil.createBrowseFileButton(icon48, icons);

		UIUtil.createLabel("128 x 128", icons);
		icon128 = new Text(icons, SWT.BORDER);
		icon128.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		icon128.setText(getFileAbsolutePath(sdkPath, "samples/icons/AIRApp_128.png"));
		UIUtil.createBrowseFileButton(icon128, icons);

		setControl(composite);
	}
	
	private String getFileAbsolutePath(String sdkPath, String path) {
		if (sdkPath == null) {
			return "";
		} 
		return new File(sdkPath, path).getAbsolutePath();
	}

	public String getApplicationId() {
		return applicationId.getText();
	}

	public String getApplicationName() {
		return applicationName.getText();
	}

	public String getCopyright() {
		return copyright.getText();
	}

	public String getApplicationDescription() {
		return description.getText();
	}

	public String getIcon128() {
		return icon128.getText();
	}

	public String getIcon16() {
		return icon16.getText();
	}

	public String getIcon32() {
		return icon32.getText();
	}

	public String getIcon48() {
		return icon48.getText();
	}

}
