package net.sf.amateras.air.wizards;

import net.sf.amateras.air.util.UIUtil;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

/**
 * The wizard page to input project properties for the HTML baesd AIR application project.
 * 
 * @author Naoki Takezoe
 */
public class AIRHTMLProjectPropertiesWizardPage extends AbstractAIRProjectPropertiesWizardPage {
	
	private Text mainHTML;
	
	protected AIRHTMLProjectPropertiesWizardPage(String pageName) {
		super(pageName, AIRProjectWizardPage.HTML_PROJECT);
	}

	protected void createProjectDependsFields(Composite parent) {
		UIUtil.createLabel("Main HTML", parent);
		mainHTML = new Text(parent, SWT.BORDER);
		mainHTML.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	}
	
	protected void projectNameChanged(String projectName) {
		super.projectNameChanged(projectName);
		mainHTML.setText(projectName + ".html");
	}

	public String getMainHTML(){
		return mainHTML.getText();
	}

}
