package net.sf.amateras.air.wizards;

import net.sf.amateras.air.util.UIUtil;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

/**
 * The wizard page to input project properties for the Flex baesd AIR application project.
 * 
 * @author Naoki Takezoe
 */
public class AIRFlexProjectPropertiesWizardPage extends AbstractAIRProjectPropertiesWizardPage {

	private Text mainSWF;
	
	protected AIRFlexProjectPropertiesWizardPage(String pageName) {
		super(pageName, AIRProjectWizardPage.FLEX_PROJECT);
	}

	protected void createProjectDependsFields(Composite parent) {
		UIUtil.createLabel("Main SWF", parent);
		mainSWF = new Text(parent, SWT.BORDER);
		mainSWF.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	}
	
	protected void projectNameChanged(String projectName) {
		super.projectNameChanged(projectName);
		mainSWF.setText(projectName + ".swf");
	}

	public String getMainSWF(){
		return mainSWF.getText();
	}

}
