package net.sf.amateras.air.wizards;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.ProcessUtil;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

/**
 * Launch <tt>adt.bat</tt> to export resources as the AIR package.
 * 
 * @author Naoki Takezoe
 */
public class ADTRunner {

	/**
	 * Launch <tt>adt.bat</tt> to export resources as the AIR package.
	 * <p>
	 * <strong>Note:</strong> This method should be called on the UI thread.
	 * 
	 * @param project AIR project
	 * @param option package options
	 * @param exportResources export resources
	 */
	public boolean run(IProject project, ArrayList<String> option, IResource[] exportResources) {
		if (exportResources != null) {
			for (int i = 0; i < exportResources.length; i++) {
				IResource resource = (IResource) exportResources[i];
				option.add(resource.getProjectRelativePath().toOSString());
			}
		}
		return run(project, option);
	}

	/**
	 * Exectute adt
	 * <p>
	 * need PreferenceStore FLEX_SDK_PATH or AIR_SDK_Path.
	 * </p>
	 * @param project
	 * @param option
	 * @return
	 */
	public boolean run(IProject project, ArrayList<String> option) {
		IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
		if (!ProcessUtil.checkAirGearProject(project)) {
			return false;
		}
		String adtPath = store.getString(AIRPlugin.PREF_ADT_COMMAND);
		String sdkPath = ProcessUtil.getAirSdkPath(adtPath);
		if (sdkPath == null) {
			return false;
		}

		File adt = new File(sdkPath, adtPath);

		File currentDir = new File(project.getLocation().toString());
		MessageConsoleStream out = createConsoleStream();
		try {

			String[] args = option.toArray(new String[option.size()]);
			Process p = ProcessUtil.createProcess(adt, args, currentDir);

			ReadStreamThread thread1 = new ReadStreamThread(p.getInputStream(), out);
			ReadStreamThread thread2 = new ReadStreamThread(p.getErrorStream(), out);
			thread1.start();
			thread2.start();

			thread1.join();
			thread2.join();

			project.refreshLocal(IResource.DEPTH_INFINITE, null);

			//			while(!thread1.isCompleted() || !thread2.isCompleted()){
			//				Thread.sleep(1000);
			//			}
			return true;

		} catch (Exception ex) {
			ex.printStackTrace();

			try {
				out.write(ex.getClass().getName() + ":" + ex.getMessage());
				out.close();
			} catch (IOException ie) {
				//
			}
			return false;
			//			ErrorDialog.openError(Display.getDefault().getActiveShell(),
			//					"Error", AIRPlugin.getResourceString("EXPORT_AIR_CAN_NOT_EXECUTE_PROCESS"),
			//					new Status(IStatus.ERROR, project.getName(), 0, ex.getMessage(), ex));
			//			return false;
		}

	}

	private MessageConsoleStream createConsoleStream() {
		MessageConsole console = new MessageConsole("ADTConsole", null);
		MessageConsoleStream stream = console.newMessageStream();

		IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
		manager.addConsoles(new IConsole[] { console });
		manager.showConsoleView(console);
		return stream;
	}

	private class ReadStreamThread extends Thread {

		private InputStream in;
		private OutputStream out;
		private boolean complete = false;

		public ReadStreamThread(InputStream in, OutputStream out) {
			this.in = in;
			this.out = out;
		}

		public void run() {
			byte[] buf = new byte[1024 * 8];
			try {
				int length = 0;
				while ((length = in.read(buf)) != -1) {
					out.write(new String(buf, 0, length).getBytes());
					System.out.print(new String(buf, 0, length).getBytes());

				}
			} catch (Exception ex) {
				ex.printStackTrace();
			} finally {
				if (in != null) {
					try {
						in.close();
					} catch (IOException ex) {
					}
				}
			}
			complete = true;
		}

		public boolean isCompleted() {
			return this.complete;
		}
	}

}
